% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareSignature.R
\name{.validatePrepareSignatureInput}
\alias{.validatePrepareSignatureInput}
\title{Validate prepareSignature input parameters}
\usage{
.validatePrepareSignatureInput(dge, geneColumn, logfcColumn, pvalColumn)
}
\arguments{
\item{dge}{A dataframe-like object containing differential gene expression data.}

\item{geneColumn}{Character string specifying the column name containing gene symbols.}

\item{logfcColumn}{Character string specifying the column name containing log fold-change values.}

\item{pvalColumn}{Character string specifying the column name containing p-values, or NA.}
}
\value{
Invisible NULL. The function throws an error if validation fails.
}
\description{
This internal function validates all input parameters for the prepareSignature
function to ensure they meet the required constraints.
}
\details{
This function performs the following validations:
\enumerate{
\item Ensures all column names are character strings
\item Validates that specified columns exist in the input dataframe
\item Checks that the dataframe is not empty
}
}
\examples{
NULL
}
\keyword{internal}
