% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getConcordants.R
\name{.validateGetConcordantsInput}
\alias{.validateGetConcordantsInput}
\title{Validate getConcordants input parameters}
\usage{
.validateGetConcordantsInput(signature, ilincsLibrary)
}
\arguments{
\item{signature}{A data.frame-like object containing the signature data.
Must have the required iLINCS signature structure with columns:
signatureID, ID_geneid, Name_GeneSymbol, Value_LogDiffExp, Significance_pvalue.}

\item{ilincsLibrary}{Character string specifying the iLINCS library to search.
Must be one of "OE", "KD", or "CP".}
}
\value{
A character vector containing the class of the input signature.
This is used internally to determine the return type format.
}
\description{
This internal function validates the input parameters for the getConcordants
function to ensure they meet the required constraints.
}
\details{
This function performs comprehensive validation:
\enumerate{
\item Ensures \code{signature} is a data.frame-like object (data.frame, tibble, or S4Vectors::DataFrame)
\item Validates complete signature structure via \code{stopIfInvalidSignature()}
\item Validates \code{ilincsLibrary} is one of the supported libraries
}

The signature must conform to the iLINCS expected structure. Use
\code{prepareSignature()} to ensure proper formatting.
}
\examples{
NULL
}
\seealso{
\verb{[ stopIfInvalidSignature() ]} for signature structure validation,
\verb{[ prepareSignature() ]} for signature preparation
}
\keyword{internal}
