% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{.returnLibrary}
\alias{.returnLibrary}
\title{Return the internal iLINCS Library ID for a given library}
\usage{
.returnLibrary(lib)
}
\arguments{
\item{lib}{A character string specifying the library name.
Must be one of "OE", "KD", or "CP".}
}
\value{
A character string containing the corresponding iLINCS library ID.
}
\description{
This internal function maps user-friendly library names to the internal
library identifiers used by the iLINCS API.
}
\details{
The mapping between user library names and iLINCS internal IDs is:
\itemize{
\item \code{"OE"} (Overexpression) -> \code{"LIB_11"}
\item \code{"KD"} (Knockdown) -> \code{"LIB_6"}
\item \code{"CP"} (Chemical Perturbagen) -> \code{"LIB_5"}
}

The function validates the input library name before mapping and will
stop execution if an invalid library is provided.
}
\examples{
NULL
}
\seealso{
\verb{[ stopIfInvalidLibraries() ]} for library validation details
}
\keyword{internal}
