% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusConcordants.R
\name{.processConsensusPipeline}
\alias{.processConsensusPipeline}
\title{Process concordants data through the complete consensus pipeline}
\usage{
.processConsensusPipeline(concordants, cutoff, cellLine)
}
\arguments{
\item{concordants}{A combined dataframe containing all concordants data.}

\item{cutoff}{Numeric similarity cutoff value.}

\item{cellLine}{Character vector of cell lines to include, or NULL.}
}
\value{
A processed dataframe with consensus concordants results.
}
\description{
This internal function orchestrates the complete processing pipeline for
consensus concordants analysis.
}
\details{
This function coordinates the following processing steps:
\enumerate{
\item Cell line filtering (if specified)
\item Similarity cutoff application
\item Target grouping and maximum similarity selection
\item Column selection and ordering
\item Target column renaming
}
}
\examples{
\dontrun{
testData <- data.frame(
    similarity = c(0.5, -0.8, 0.2),
    compound = c("A", "B", "C"),
    cellline = c("A375", "PC3", "A375")
)
processed <- .processConsensusPipeline(testData, 0.3, "A375")
}
}
\keyword{internal}
