% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusConcordants.R
\name{.filterByCellLine}
\alias{.filterByCellLine}
\title{Filter concordants data by cell line}
\usage{
.filterByCellLine(concordants, cellLine)
}
\arguments{
\item{concordants}{A dataframe containing concordants data.}

\item{cellLine}{A character vector of cell lines to include, or NULL for no filtering.}
}
\value{
A filtered dataframe containing only the specified cell lines.
}
\description{
This internal function filters the concordants data to include only
the specified cell lines.
}
\details{
This function:
\enumerate{
\item Filters data based on the cellline column
\item Returns original data if cellLine is NULL
\item Handles cases where no data matches the specified cell lines
}
}
\examples{
\dontrun{
testData <- data.frame(
    similarity = c(0.5, -0.3, 0.7),
    cellline = c("A375", "PC3", "MCF7")
)
filtered <- .filterByCellLine(testData, c("A375", "PC3"))
}
}
\keyword{internal}
