% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getConcordants.R
\name{.executeIlincsRequest}
\alias{.executeIlincsRequest}
\title{Execute iLINCS API request with error handling}
\usage{
.executeIlincsRequest(request, verbose = FALSE)
}
\arguments{
\item{request}{An httr2_request object to be executed.}

\item{verbose}{Logical indicating whether to display request details.
Default is FALSE.}
}
\value{
An httr2_response object, including error responses that would
normally cause httr2 to raise an error.
}
\description{
This internal function safely executes an httr2 request and captures errors
instead of raising them, allowing downstream functions to handle them appropriately.
}
\details{
This function configures the request to not raise errors automatically
on HTTP error status codes (4xx, 5xx) by using \code{httr2::req_error()}.
Instead, error responses are returned as response objects that can be
processed by \code{.processIlincsResponse()} to generate appropriate
error messages with context.

The function handles:
\itemize{
\item Network connection errors
\item HTTP error status codes (400, 401, 403, 404, 500, etc.)
\item Timeout errors
\item Other httr2 request failures
}
}
\examples{
NULL
}
\keyword{internal}
