% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterSignature.R
\name{.calculateAbsoluteThresholds}
\alias{.calculateAbsoluteThresholds}
\title{Calculate thresholds using absolute threshold values}
\usage{
.calculateAbsoluteThresholds(threshold)
}
\arguments{
\item{threshold}{A numeric value or vector specifying the absolute threshold(s).

Can be:

\if{html}{\out{<div class="sourceCode">}}\preformatted{- A single value: Dispatched to [.calculateSingleThreshold()]
- A vector of two values: Dispatched to [.calculateDoubleThreshold()]
}\if{html}{\out{</div>}}}
}
\value{
A named list with two elements:
\itemize{
\item \code{downThreshold}: The threshold for down-regulated genes
\item \code{upThreshold}: The threshold for up-regulated genes
}
}
\description{
This internal function coordinates the calculation of filtering thresholds
when absolute threshold values are provided. It dispatches to the appropriate
calculation function based on the number of threshold values provided.
}
\details{
This function serves as a dispatcher that:
\itemize{
\item Checks the length of the threshold parameter
\item Calls the appropriate threshold calculation function
\item Throws an error if an invalid number of thresholds is provided
}

The function ensures that only single values or pairs of values are accepted,
maintaining the integrity of the filtering logic.
}
\examples{
\dontrun{
# Single threshold - creates symmetric thresholds
thresholds <- .calculateAbsoluteThresholds(1.0)
# Returns: list(downThreshold = -1.0, upThreshold = 1.0)

# Double threshold - uses provided values
thresholds <- .calculateAbsoluteThresholds(c(-1.5, 2.0))
# Returns: list(downThreshold = -1.5, upThreshold = 2.0)

# Invalid - too many values (will throw error)
# thresholds <- .calculateAbsoluteThresholds(c(1.0, 2.0, 3.0))
}
}
\keyword{internal}
