% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusConcordants.R
\name{.applyTargetRenaming}
\alias{.applyTargetRenaming}
\title{Apply target column renaming to consensus results}
\usage{
.applyTargetRenaming(concordants)
}
\arguments{
\item{concordants}{A dataframe containing selected consensus results.}
}
\value{
A dataframe with renamed columns following consensus output standards.
}
\description{
This internal function applies the standard target column renaming
to produce the final consensus concordants output format.
}
\details{
This function:
\enumerate{
\item Applies targetRename function to standardize column names
\item Converts internal column names to user-facing consensus format
\item Handles different library types appropriately
}
}
\examples{
\dontrun{
testData <- data.frame(
    signatureid = "SIG1",
    compound = "A",
    cellline = "A375",
    similarity = 0.8
)
renamed <- .applyTargetRenaming(testData)
}
}
\keyword{internal}
