% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dreamlet.R
\name{topTable,dreamletResult-method}
\alias{topTable,dreamletResult-method}
\alias{topTable,dreamletResult,dreamletResult-method}
\title{Table of Top Genes from dreamlet fit}
\usage{
\S4method{topTable}{dreamletResult}(
  fit,
  coef = NULL,
  number = 10,
  genelist = NULL,
  adjust.method = "BH",
  sort.by = "P",
  resort.by = NULL,
  p.value = 1,
  lfc = 0,
  confint = FALSE
)
}
\arguments{
\item{fit}{dreamletResult object}

\item{coef}{coef}

\item{number}{number}

\item{genelist}{genelist}

\item{adjust.method}{adjust.method}

\item{sort.by}{sort.by}

\item{resort.by}{resort.by}

\item{p.value}{p.value}

\item{lfc}{lfc}

\item{confint}{confint}
}
\value{
\code{data.frame} storing hypothesis test for each gene and cell type
}
\description{
Extract a table of the top-ranked genes from a dreamlet fit.
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Differential expression analysis within each assay,
# evaluated on the voom normalized data
res.dl <- dreamlet(res.proc, ~group_id)

# show coefficients estimated for each cell type
coefNames(res.dl)

# extract results using limma-style syntax
# combines all cell types together
# adj.P.Val gives study-wide FDR
topTable(res.dl, coef = "group_idstim", number = 3)

}
\seealso{
\code{limma::topTable()}, \code{variancePartition::topTable()}
}
