% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dreamlet.R, R/dreamletProcessedData.R, R/vpDF.R
\name{seeErrors}
\alias{seeErrors}
\alias{seeErrors,dreamletResult-method}
\alias{seeErrors,dreamletProcessedData-method}
\alias{seeErrors,vpDF-method}
\title{Get error text}
\usage{
seeErrors(obj)

\S4method{seeErrors}{dreamletResult}(obj)

\S4method{seeErrors}{dreamletProcessedData}(obj)

\S4method{seeErrors}{vpDF}(obj)
}
\arguments{
\item{obj}{A \code{dreamletResult} object}
}
\value{
\code{tibble} storing error text
}
\description{
Get error text
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Differential expression analysis within each assay,
# evaluated on the voom normalized data
res.dl <- dreamlet(res.proc, ~group_id)

# show errors
# but none are reported
res.err = seeErrors(res.dl)

}
