% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGeneHeatmap.R
\docType{methods}
\name{plotGeneHeatmap}
\alias{plotGeneHeatmap}
\alias{plotGeneHeatmap,dreamletResult-method}
\alias{plotGeneHeatmap,dreamletResult,dreamletResult-method}
\title{Heatmap of genes and assays}
\usage{
plotGeneHeatmap(
  x,
  coef,
  genes,
  assays = assayNames(x),
  zmax = NULL,
  transpose = FALSE
)

\S4method{plotGeneHeatmap}{dreamletResult}(
  x,
  coef,
  genes,
  assays = assayNames(x),
  zmax = NULL,
  transpose = FALSE
)
}
\arguments{
\item{x}{A \code{dreamletResult} object}

\item{coef}{column number or column name specifying which coefficient or contrast of the linear model is of interest.}

\item{genes}{array of genes to include in plot}

\item{assays}{array of assay names to include in analysis. Defaults to \code{assayNames(x)}}

\item{zmax}{maximum z.std value}

\item{transpose}{(default: FALSE) Use `coord_flip()` to flip axies}
}
\value{
Heatmap plot for specified genes and assays

Heatmap plot for specified genes and assays
}
\description{
Heatmap of genes and assays
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# voom-style normalization
res.proc <- processAssays(pb, ~group_id)

# Differential expression analysis within each assay,
# evaluated on the voom normalized data
res.dl <- dreamlet(res.proc, ~group_id)

# Heatmap for specified subset of genes
plotGeneHeatmap(res.dl, coef = "group_idstim", genes = rownames(pb)[1:15])

}
