% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellTypeSpecificity.R
\name{cellTypeSpecificity}
\alias{cellTypeSpecificity}
\title{Get cell type specificity of gene expression}
\usage{
cellTypeSpecificity(pb, ...)
}
\arguments{
\item{pb}{\code{SingleCellExperiment} of pseudobulk data where easy \code{assay} is a cell type.}

\item{...}{other arguments passed to \code{edgeR::calcNormFactors()}}
}
\value{
matrix of the fraction of expression attributable to each cell type for each gene.
}
\description{
For each gene, compute fraction of overall expression attributable to each cell type
}
\details{
Sum counts for each cell type, and compute the fraction of counts-per-million attributable to each cell type for each gene
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

# create pseudobulk for each sample and cell cluster
pb <- aggregateToPseudoBulk(example_sce,
  assay = "counts",
  cluster_id = "cluster_id",
  sample_id = "sample_id",
  verbose = FALSE
)

# Compute cell type specificity of each gene
df <- cellTypeSpecificity(pb)

# Violin plot of specificity scores for each cell type
# Dashed line indicates genes that are equally expressed
# across all cell types.  For K cell types, this is 1/K
plotViolin(df)

# Compute the maximum specificity score for each gene
scoreMax <- apply(df, 1, max)
head(scoreMax)

# For each cell type, get most specific gene
genes <- rownames(df)[apply(df, 2, which.max)]

# Barplot of 5 genes
plotPercentBars(df, genes = genes)

# heatmap of 5 genes that are most cell type specific
dreamlet::plotHeatmap(df, genes = genes)

}
