% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processAssays.R
\name{processOneAssay}
\alias{processOneAssay}
\title{Processing expression data from assay}
\usage{
processOneAssay(
  y,
  formula,
  data,
  n.cells,
  min.cells = 5,
  min.count = 2,
  min.samples = 4,
  min.prop = 0.4,
  min.total.count = 15,
  isCounts = TRUE,
  normalize.method = "TMM",
  span = "auto",
  quiet = TRUE,
  weights = NULL,
  rescaleWeightsAfter = FALSE,
  BPPARAM = SerialParam(),
  ...
)
}
\arguments{
\item{y}{matrix of counts or log2 CPM}

\item{formula}{regression formula for differential expression analysis}

\item{data}{metadata used in regression formula}

\item{n.cells}{array of cell count for each sample}

\item{min.cells}{minimum number of observed cells for a sample to be included in the analysis}

\item{min.count}{used to compute a CPM threshold of \code{CPM.cutoff = min.count/median(lib.size)*1e6}.  Passed to \code{edgeR::filterByExpr()}}

\item{min.samples}{minimum number of samples passing cutoffs for cell cluster to be retained}

\item{min.prop}{minimum proportion of retained samples with \code{CPM > CPM.cutoff}}

\item{min.total.count}{minimum total count required per gene for inclusion}

\item{isCounts}{logical, indicating if data is raw counts}

\item{normalize.method}{normalization method to be used by \code{calcNormFactors}}

\item{span}{Lowess smoothing parameter using by \code{variancePartition::voomWithDreamWeights()}}

\item{quiet}{show messages}

\item{weights}{matrix of precision weights}

\item{rescaleWeightsAfter}{default = FALSE, should the output weights be scaled by the input weights}

\item{BPPARAM}{parameters for parallel evaluation}

\item{...}{other arguments passed to \code{dream}}
}
\value{
\code{EList} object storing log2 CPM and precision weights
}
\description{
For raw counts, filter genes and samples, then estimate precision weights using linear mixed model weighting by number of cells observed for each sample.  For normalized data, only weight by number of cells
}
\seealso{
\code{processAssays()}
}
