% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\name{draw_phospho}
\alias{draw_phospho}
\title{Add protein phosphorylation sites to ggplot2 object.}
\usage{
draw_phospho(p, data = data, size = 2,
         fill = "yellow", alpha = 1.0, show.legend = FALSE)
}
\arguments{
\item{p}{ggplot2 object ideally created with \code{\link{draw_canvas}}.}

\item{data}{Dataframe of one or more rows with the following column
names: 'type', 'description', 'begin', 'end', 'length', 'accession',
'entryName', 'taxid', 'order'. Must contain a minimum of one "CHAIN" as
data$type.}

\item{size}{Size of the circle}

\item{fill}{Colour of the circle.}

\item{alpha}{Transparency of the circles representing the protein
phosphorylation sites.}

\item{show.legend}{Option to include legend in this layer}
}
\value{
A ggplot2 object either in the plot window or as an object with an
additional geom_point layer.
}
\description{
\code{draw_phospho} adds phosphorylation sites to ggplot2 object created by
\code{\link{draw_canvas}} and \code{\link{draw_chains}}.
It uses the data object.
The ggplot2 function
\code{\link[ggplot2]{geom_point}} is used to draw each of the
phosphorylation sites at their location as determined by data object.
}
\examples{
# combines will with draw_domains to plot chains and phosphorylation sites.
data("five_rel_data")
p <- draw_canvas(five_rel_data)
p <- draw_chains(p, five_rel_data, label_size = 1.25)
draw_phospho(p, five_rel_data)

}
