% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\name{draw_folding}
\alias{draw_folding}
\title{Add regions to ggplot object: alpha-helixes, beta-strands and turns.}
\usage{
draw_folding(p, data = data,
show.legend = TRUE,show_strand = TRUE,show_helix = TRUE, show_turn = TRUE,
alpha = 1.0)
}
\arguments{
\item{p}{ggplot2 object ideally created with \code{\link{draw_canvas}}.}

\item{data}{Dataframe of one or more rows with the following column
names: 'type', 'description', 'begin', 'end', 'length', 'accession',
'entryName', 'taxid', 'order'. Uses STRAND, HELIX and TURN type to indicate
these parts of the proteins.}

\item{show.legend}{Option to include legend in this layer}

\item{show_strand}{Option to show STRAND in this layer}

\item{show_helix}{Option to show HELIX in this layer}

\item{show_turn}{Option to show TURN in this layer}

\item{alpha}{alpha Transparency of the rectangles representing the folds.}
}
\value{
A ggplot2 object either in the plot window or as an object with an
additional geom_rect layer.
}
\description{
\code{draw_folding} adds alpha-helixes, beta-strands and turns to the
ggplot2 object created by \code{\link{draw_chains}}.
It uses the data object.
The ggplot2 function \code{geom_rect} is used to draw parts of the protein
chain which has alpha-helixes, beta-strands and turns proportional to the
number of amino acids (length).
}
\examples{
# combines with draw_chains to colour chain with helicies, strands and turns.
data("five_rel_data")
p <- draw_canvas(five_rel_data)
p <- draw_chains(p, five_rel_data, label_size = 1.25)
draw_folding(p, five_rel_data)



}
