% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fxns.R
\name{render_circos_ligand_receptor}
\alias{render_circos_ligand_receptor}
\title{Render Circos Ligand Receptor Plot}
\usage{
render_circos_ligand_receptor(
  signaling_df,
  receptor,
  cell_colors = NULL,
  ligand_expression_threshold = 0.01
)
}
\arguments{
\item{signaling_df}{Data frame output from \code{\link[=obtain_circos_expression]{obtain_circos_expression()}}}

\item{receptor}{Name of a receptor active in at least one cell type in the domino object}

\item{cell_colors}{Named vector of color names or hex codes where names correspond to the plotted cell types and the color values}

\item{ligand_expression_threshold}{Minimum mean expression value of a ligand by a cell type for a chord to be rendered between the cell type and the receptor}
}
\value{
a circlize plot is rendered to the active graphics device
}
\description{
Renders a circos plot from the output of \code{\link[=obtain_circos_expression]{obtain_circos_expression()}} to the active graphics device
}
\examples{
example(build_domino, echo = FALSE)
#basic usage
circos_df <- obtain_circos_expression(pbmc_dom_built_tiny, receptor = "CXCR3", ligands = "CCL20")
render_circos_ligand_receptor(signaling_df = circos_df, receptor = "CXCR3")

}
