% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fxns.R
\name{gene_network}
\alias{gene_network}
\title{Create a gene association network}
\usage{
gene_network(
  dom,
  clust = NULL,
  OutgoingSignalingClust = NULL,
  class_cols = c(lig = "#FF685F", rec = "#47a7ff", feat = "#39C740"),
  cols = NULL,
  lig_scale = 1,
  layout = "grid",
  ...
)
}
\arguments{
\item{dom}{Domino object with network built (\code{\link[=build_domino]{build_domino()}})}

\item{clust}{Receptor cluster to create the gene association network for. A vector of clusters may be provided.}

\item{OutgoingSignalingClust}{Vector of clusters to plot the outgoing signaling from}

\item{class_cols}{Named vector of colors used to color classes of vertices. Values must be colors and names must be classes ('rec', 'lig', and 'feat' for receptors, ligands, and features.).}

\item{cols}{Named vector of colors for individual genes. Genes not included in this vector will be colored according to class_cols.}

\item{lig_scale}{FALSE or a numeric value to scale the size of ligand vertices based on z-scored expression in the data set.}

\item{layout}{Type of layout to use. Options are 'grid', 'random', 'sphere', 'circle', 'fr' for Fruchterman-Reingold force directed layout, and 'kk' for Kamada Kawai for directed layout.}

\item{...}{Other parameters to pass to plot() with an \href{https://r.igraph.org/}{igraph} object. See \href{https://r.igraph.org/}{igraph} manual for options.}
}
\value{
An igraph plot rendered to the active graphics device
}
\description{
Create a gene association network for genes from a given cluster. The
selected cluster acts as the receptor for the gene association network, so
only ligands, receptors, and features associated with the receptor cluster
will be included in the plot.
}
\examples{
#basic usage
example(build_domino, echo = FALSE)
gene_network(
 pbmc_dom_built_tiny, clust = "CD8_T_cell", 
 OutgoingSignalingClust = "CD14_monocyte")

}
