% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fxns.R
\name{cor_scatter}
\alias{cor_scatter}
\title{Create a correlation plot between TF and receptor}
\usage{
cor_scatter(dom, tf, rec, remove_rec_dropout = TRUE, ...)
}
\arguments{
\item{dom}{Domino object with network built (\code{\link[=build_domino]{build_domino()}})}

\item{tf}{Target TF for plottting AUC score}

\item{rec}{Target receptor for plotting expression}

\item{remove_rec_dropout}{Whether to remove cells with zero expression for plot. This should match the same setting as in \code{\link[=build_domino]{build_domino()}}.}

\item{...}{Other parameters to pass to \code{\link[ggpubr:ggscatter]{ggpubr::ggscatter()}}.}
}
\value{
A ggplot scatter plot rendered in the active graphics device
}
\description{
Create a correlation plot between transcription factor activation score and receptor expression
}
\examples{
example(build_domino, echo = FALSE)
cor_scatter(pbmc_dom_built_tiny, "FLI1","CXCR3")

}
