% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\docType{data}
\name{BS.chr21}
\alias{BS.chr21}
\title{BS.chr21: Whole-genome bisulfite sequencing for chromosome 21 
from Lister et al.}
\format{
An object of class \code{BSseq}.
}
\source{
Obtained from 
\url{http://neomorph.salk.edu/human_methylome/data.html} specifically,
 the files \url{mc_h1_r1.tar.gz}, \url{mc_h1_r2.tar.gz}, 
 \url{mc_imr90_r1.tar.gz}, \url{mc_imr90_r2.tar.gz}
 A script which downloads these files and constructs the \code{BS.chr21} 
 object may be found in \file{inst/scripts/get_BS.chr21.R} - this was 
 based off of and modified from the get_BS.chr22.R script in the 
 \code{bsseq} package. The object constructed here contains a 
 different chromosome (22 instead of 21), and two additional samples
 (h1 and imr90 instead of just imr90) to enable identification of
 cell type-DMRs for examples.
}
\usage{
data(BS.chr21)
}
\description{
This dataset represents chromosome 21 
from the IMR90 and H1 cell lines sequenced in Lister et al.  
Only CpG methylation are included. The two samples from 
each cell line are two different extractions (ie. technical replicates), 
and are pooled in the analysis in the original paper.
}
\details{
All coordinates are in hg18.
}
\examples{
  data(BS.chr21)
  BS.chr21
}
\references{
R Lister et al. \emph{Human DNA methylomes at base 
 resolution show widespread epigenomic differences}. Nature (2009) 462,
  315-322.
}
\keyword{datasets}
