% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{findMultivariateGammaWithSupport}
\alias{findMultivariateGammaWithSupport}
\title{Find optimal gamma and corresponding support for list of feature sets}
\usage{
findMultivariateGammaWithSupport(seMat, FeatureSets, gamma = 1:9/10,
  beta = 0.95, alpha = 0.01, distance = "euclidean",
  verbose = TRUE)
}
\arguments{
\item{seMat}{SummariziedExperiment with an assay in [0, 1], with each column corresponding to a sample and each 
row corresponding to a feature; usually in quantile form.}

\item{FeatureSets}{The multivariate features in list or matrix form. In list form, each list element
should be a vector of individual features; in matrix form, it should be a binary matrix with rownames
being individual features and column names being the names of the feature sets.}

\item{gamma}{Range of gamma values to search through. 
By default gamma = \{0.01, 0.02, ... 0.09, 0.1, 0.2, ..., 0.9\}.}

\item{beta}{Parameter for eliminating outliers (0 < beta <= 1). By default beta=0.95.}

\item{alpha}{Expected proportion of divergent features per sample to be estimated
over the samples in Mat. By default alpha = 0.01; i.e. search for the smallest gamma that provides
1\% or less number of divergent features per sample.}

\item{distance}{Type of distance to be calculated between points. Any type of distance that can be passed on
to the dist function can be used (default 'euclidean').}

\item{verbose}{Logical indicating whether to print status related messages during computation (defaults
to TRUE).}
}
\value{
A list with elements:
	Support: a matrix indicating which samples were included in the support.
	Baseline: a list where each element is the baseline of a multivariate feature. 
	featureMat: the multivariate features in matrix form.
	alpha: the expected number of divergent multivariate features per sample.
	gamma: the gamma parameter selected.
	distance: the type of distance used for baselien computation.
		optimal: TRUE or FALSE indicating whether the alpha criteria was met
		alpha_space: the alpha values correspinding to the gamma values searched through
}
\description{
Function for searching through a range of gamma values for finding the smallest gamma and support that 
provides expected proportion of divergent features per sample less than or equal to alpha.
}
\examples{
baseMat = breastTCGA_Mat[, breastTCGA_Group == "NORMAL"]
seMat.base = SummarizedExperiment(assays=list(data=baseMat))
assays(seMat.base)$quantile = computeQuantileMatrix(seMat.base)
baseline = findMultivariateGammaWithSupport(seMat=seMat.base, FeatureSets=msigdb_Hallmarks)

}
\keyword{gamma}
