% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGenomicState.R
\name{makeGenomicState}
\alias{makeGenomicState}
\title{Obtain the genomic state per region from annotation}
\usage{
makeGenomicState(txdb, chrs = c(seq_len(22), "X", "Y"), ...)
}
\arguments{
\item{txdb}{A \link[GenomicFeatures:TxDb-class]{TxDb} object with chromosome lengths
(check \code{seqlengths(txdb)}). If you are using a
\link[GenomicFeatures:TxDb-class]{TxDb} object created from a GFF/GTF file, you will
find this \url{https://support.bioconductor.org/p/93235/} useful.}

\item{chrs}{The names of the chromosomes to use as denoted in the
\code{txdb} object. Check \link[GenomicFeatures:TxDb-class]{isActiveSeq}.}

\item{...}{Arguments passed to \link{extendedMapSeqlevels}.}
}
\value{
A \code{GRangesList} object with two elements: \code{fullGenome} and
\code{codingGenome}. Both have metadata information for the type of region
(theRegion), transcript IDs (tx_id), transcript name (tx_name), and gene ID
(gene_id). \code{fullGenome} classifies each region as either being exon,
intron or intergenic. \code{codingGenome} classfies the regions as being
promoter, exon, intro, 5UTR, 3UTR or intergenic.
}
\description{
This function summarizes the annotation contained in a
\link[GenomicFeatures:TxDb-class]{TxDb} at each given base of the genome based
on annotated transcripts. It groups contiguous base pairs classified as the
same type into regions.
}
\examples{
## Load the example data base from the GenomicFeatures vignette
library("GenomicFeatures")
samplefile <- system.file("extdata", "hg19_knownGene_sample.sqlite",
    package = "GenomicFeatures"
)
txdb <- loadDb(samplefile)

## Generate genomic state object, only for chr6
sampleGenomicState <- makeGenomicState(txdb, chrs = "chr6")
#
\dontrun{
## Create the GenomicState object for Hsapiens.UCSC.hg19.knownGene
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene

## Creating this GenomicState object takes around 8 min for all chrs and
## around 30 secs for chr21
GenomicState.Hsapiens.UCSC.hg19.knownGene.chr21 <-
    makeGenomicState(txdb = txdb, chrs = "chr21")

## For convinience, this object is already included in derfinder
library("testthat")
expect_that(
    GenomicState.Hsapiens.UCSC.hg19.knownGene.chr21,
    is_equivalent_to(genomicState)
)

## Hsapiens ENSEMBL GRCh37
library("GenomicFeatures")
## Can take several minutes and speed will depend on your internet speed
xx <- makeTxDbPackageFromBiomart(
    version = "0.99", maintainer = "Your Name",
    author = "Your Name"
)
txdb <- loadDb(file.path(
    "TxDb.Hsapiens.BioMart.ensembl.GRCh37.p11", "inst",
    "extdata", "TxDb.Hsapiens.BioMart.ensembl.GRCh37.p11.sqlite"
))

## Creating this GenomicState object takes around 13 min
GenomicState.Hsapiens.ensembl.GRCh37.p11 <- makeGenomicState(
    txdb = txdb,
    chrs = c(1:22, "X", "Y")
)

## Save for later use
save(GenomicState.Hsapiens.ensembl.GRCh37.p11,
    file = "GenomicState.Hsapiens.ensembl.GRCh37.p11.Rdata"
)
}

}
\seealso{
\link[GenomicFeatures:TxDb-class]{TxDb}
}
\author{
Andrew Jaffe, Leonardo Collado-Torres
}
