% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createBwSample.R
\name{createBwSample}
\alias{createBwSample}
\title{Create a BigWig file with the coverage information for a given sample}
\usage{
createBwSample(sample, path = ".", fullCov, keepGR = TRUE, ...)
}
\arguments{
\item{sample}{The name or integer index of the sample of interest to coerce
to a \code{GRanges} object.}

\item{path}{The path where the BigWig file will be created.}

\item{fullCov}{A list where each element is the result from
\link{loadCoverage} used with \code{returnCoverage = TRUE}. Can be generated
using \link{fullCoverage}.}

\item{keepGR}{If \code{TRUE}, the \link[GenomicRanges:GRanges-class]{GRanges} object
created by \link{coerceGR} is returned. Otherwise it is discarded.}

\item{...}{Arguments passed to other methods and/or advanced arguments.
Advanced arguments:
\describe{
\item{verbose }{ If \code{TRUE} basic status updates will be printed along
the way.}
}
Passed to \link{coerceGR}.}
}
\value{
Creates a BigWig file with the coverage information (regions with
coverage greater than zero) for a given sample. If \code{keepGR} it returns
the output from \link{coerceGR}.
}
\description{
Given the output of \link{fullCoverage}, this function coerces the coverage
to a \link[GenomicRanges:GRanges-class]{GRanges} object using \link{coerceGR} and then
exports the coverage to a BigWig file using
\link[rtracklayer:BigWigFile]{export.bw}.
}
\examples{
## Create a small fullCov object with data only for chr21
fullCov <- list("chr21" = genomeDataRaw)

## Create a BigWig for the first sample in a test directory
dir.create("createBwSample-example")
bw <- createBwSample("ERR009101", "createBwSample-example",
    fullCov = fullCov, seqlengths = c("chr21" = 48129895)
)

## Explore the output
bw

## Exports a single sample to a BigWig file
}
\seealso{
\link[GenomicRanges:GRanges-class]{GRanges},
\link[rtracklayer:BigWigFile]{export.bw},
link{coerceGR}
}
\author{
Leonardo Collado-Torres
}
