% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createBw.R
\name{createBw}
\alias{createBw}
\title{Export coverage to BigWig files}
\usage{
createBw(fullCov, path = ".", keepGR = TRUE, ...)
}
\arguments{
\item{fullCov}{A list where each element is the result from
\link{loadCoverage} used with \code{returnCoverage = TRUE}. Can be generated
using \link{fullCoverage}.}

\item{path}{The path where the BigWig files will be created.}

\item{keepGR}{If \code{TRUE}, the \link[GenomicRanges:GRanges-class]{GRanges} objects
created by \link{coerceGR} grouped into a \link[GenomicRanges:GRangesList-class]{GRangesList}
are returned. Otherwise they are discarded.}

\item{...}{Arguments passed to \link{createBwSample}.}
}
\value{
If \code{keepGR = TRUE}, then a \link[GenomicRanges:GRangesList-class]{GRangesList}
with the output for \link{coerceGR} for each of the samples.
}
\description{
Using output from \link{fullCoverage}, export the coverage from all the
samples to BigWig files using \link{createBwSample}.
}
\details{
Use at most one core per chromosome.
}
\examples{
## Create a small fullCov object with data only for chr21
fullCov <- list("chr21" = genomeDataRaw)

## Keep only 2 samples
fullCov$chr21$coverage <- fullCov$chr21$coverage[c(1, 31)]

## Create the BigWig files for all samples in a test dir
dir.create("createBw-example")
bws <- createBw(fullCov, "createBw-example")

## Explore the output
bws

## First sample
bws[[1]]

## Note that if a sample has no bases with coverage > 0, the GRanges object
## is empty and no BigWig file is created for that sample.
bws[[2]]


## Exports fullCoverage() output to BigWig files
}
\seealso{
\link[GenomicRanges:GRangesList-class]{GRangesList},
\link[rtracklayer:BigWigFile]{export.bw},
\link{createBwSample}, \link{coerceGR}
}
\author{
Leonardo Collado-Torres
}
