% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reassign.R
\name{reassign}
\alias{reassign}
\title{Reassign cells using knn}
\usage{
reassign(
  sce,
  k = 10,
  d = 10,
  train_cells = sce$train,
  predict_cells = sce$predict
)
}
\arguments{
\item{sce}{object of class SingleCellExperiment}

\item{k}{number of neighbours used in knn, defaults to 10}

\item{d}{number of doublets per group combination to simulate, defaults to 10}

\item{train_cells}{logical vector specifying which cells to use to train
classifier}

\item{predict_cells}{logical vector specifying which cells to classify}
}
\value{
A SingleCellExperiment with updated group assignments called 'knn'
}
\description{
k-nearest neighbour classification of cells.
Training data is intended to be labels of cells confidently called using
cell hashing based methods and their corresponding SNPs.
Prediction data can be remaining cells but can also include the training
data.
Doublets are simulated by randomly combining 'd' SNP profiles from each
grouping combination.
}
\examples{
data(multiplexed_scrnaseq_sce, vartrix_consensus_snps)
multiplexed_scrnaseq_sce <- high_conf_calls(multiplexed_scrnaseq_sce)
multiplexed_scrnaseq_sce <- add_snps(sce = multiplexed_scrnaseq_sce, 
mat = vartrix_consensus_snps, 
thresh = 0.8)
multiplexed_scrnaseq_sce <- reassign(sce = multiplexed_scrnaseq_sce, k = 10)

}
