#' Hg19 genomic information of anchor CpGs (i.e., all-tissue unmethylated/methylation
#' probes) inferred from DNA methylation atlas published by Moss 2018 Nat. Commun.
#' (https://www.nature.com/articles/s41467-018-07466-6). Used as default in \code{\link{decemedip}}.
#'
#'
#' @docType data
#' @description This dataset represents a GRanges object that contains the collection
#' of Illumina HumanMethylation450K probes that have methylation level less than 0.1 or
#' greater than 0.9 in all tissue present in the atlas. Data source is from the MethAtlas
#' GitHub repo (\url{https://github.com/nloyfer/meth_atlas}).
#' @importFrom utils data
#' @usage data(hg19.ref.anc.se)
#' @format An object of class \code{SummarizedExperiment}.
#'
#' @details All coordinates are in hg19.
#' @references Moss, J., Magenheim, J., Neiman, D. et al. Comprehensive human
#' cell-type methylation atlas reveals origins of circulating cell-free DNA in
#' health and disease. \emph{Nat Commun 9, 5068} (2018).
#'
#' @examples
#' data(hg19.ref.anc.se)
#' hg19.ref.anc.se
"hg19.ref.anc.se"

#' Hg19 genomic information of cell-type-specific marker CpGs inferred from DNA
#' methylation atlas published by Moss 2018 Nat. Commun.
#' (https://www.nature.com/articles/s41467-018-07466-6).
#'
#'
#' @docType data
#' @description Default reference cell type-specific markers used as default in
#' \code{\link{decemedip}}. This dataset represents a GRanges object that contains the collection
#' of Illumina HumanMethylation450K probes that have methylation level less than 0.1 or
#' greater than 0.9 in all tissue present in the atlas. Data source of the methylation atlas is
#' from the MethAtlas GitHub repo (https://github.com/nloyfer/meth_atlas). For details
#' of how the marker CpGs are selected, please refer to the decemedip manuscript.
#' @importFrom utils data
#' @usage data(hg19.ref.cts.se)
#' @format An object of class \code{SummarizedExperiment}. rowData(hg19.ref.cts.se) contains
#' information of the selected probes.
#'
#' @details All coordinates are in hg19.
#' @references Moss, J., Magenheim, J., Neiman, D. et al. Comprehensive human
#' cell-type methylation atlas reveals origins of circulating cell-free DNA in
#' health and disease. \emph{Nat Commun 9, 5068} (2018).
#' https://doi.org/10.1038/s41467-018-07466-6
#'
#' @examples
#' data(hg19.ref.cts.se)
#' hg19.ref.cts.se
"hg19.ref.cts.se"

#' Hg38 genomic information of cell-type-specific marker CpGs inferred from DNA
#' methylation atlas published by Moss 2018 Nat. Commun.
#' (https://www.nature.com/articles/s41467-018-07466-6).
#'
#' @docType data
#' @description Same as \code{data(hg19.ref.anc.se)} but lifted over to hg38.
#' @format An object of class \code{SummarizedExperiment}.
#'
#' @details All coordinates are in hg38.
#' @importFrom utils data
#' @usage data(hg38.ref.anc.se)
#' @format An object of class \code{SummarizedExperiment}.
#'
#' @examples
#' data(hg38.ref.anc.se)
#' hg38.ref.anc.se
"hg38.ref.anc.se"


#' Hg38 genomic information of cell-type-specific marker CpGs inferred from DNA
#' methylation atlas published by Moss 2018 Nat. Commun.
#' (https://www.nature.com/articles/s41467-018-07466-6).
#'
#' @docType data
#' @description Same as \code{data(hg19.ref.cts.se)} but lifted over to hg38.
#' @format An object of class \code{SummarizedExperiment}.
#'
#' @details All coordinates are in hg38.
#' @importFrom utils data
#' @usage data(hg38.ref.cts.se)
#' @format An object of class \code{SummarizedExperiment}.
#'
#' @examples
#' data(hg38.ref.cts.se)
#' hg38.ref.cts.se
"hg38.ref.cts.se"


#' MeDIP-seq read counts on reference cell type-specific CpGs of 3 PDX samples from Berchuck et al. 2022
#'
#' @docType data
#' @description This dataset represents a \code{SummarizedExperiment} object that contains
#' MeDIP-seq read counts on reference cell type-specific CpGs of 3 PDX samples from Berchuck
#' et al. 2022. Each row is a CpG.
#' @importFrom utils data
#' @usage data(pdx.counts.cts.se)
#' @format An object of class \code{SummarizedExperiment}.
#'
#' @details All coordinates are in hg19.
#'
#' @examples
#' data(pdx.counts.cts.se)
#' pdx.counts.cts.se
"pdx.counts.cts.se"

#' MeDIP-seq read counts on reference anchor CpGs of 3 PDX samples from Berchuck et al. 2022
#'
#' @docType data
#' @description This dataset represents a \code{SummarizedExperiment} object that contains
#' MeDIP-seq read counts on reference anchor CpGs of 3 PDX samples from Berchuck
#' et al. 2022. Each row is a CpG.
#' @importFrom utils data
#' @usage data(pdx.counts.anc.se)
#' @format An object of class \code{SummarizedExperiment}.
#'
#' @details All coordinates are in hg19.
#'
#' @examples
#' data(pdx.counts.anc.se)
#' pdx.counts.anc.se
"pdx.counts.anc.se"


#' Subset of hg19.ref.anc.se as a lightweighted example
#' @docType data
#' @description Subset of hg19.ref.anc.se as a lightweighted example, only
#' contains the blood cell types and prostate.
#' @importFrom utils data
#' @usage data(example.hg19.ref.anc.se)
#' @format An object of class \code{SummarizedExperiment}.
#'
#' @details All coordinates are in hg19.
"example.hg19.ref.anc.se"

#' Subset of hg19.ref.cts.se as a lightweighted example
#' @docType data
#' @description Subset of hg19.ref.cts.se as a lightweighted example, only
#' contains the blood cell types and prostate.
#' @importFrom utils data
#' @usage data(example.hg19.ref.cts.se)
#' @format An object of class \code{SummarizedExperiment}.
#'
#' @details All coordinates are in hg19.
"example.hg19.ref.cts.se"


#' Subset of pdx.counts.anc.se as a lightweighted example
#'
#' @docType data
#' @description Subset of pdx.counts.anc.se as a lightweighted example, only
#' contains the blood cell types and prostate.
#' @importFrom utils data
#' @usage data(example.pdx.counts.anc.se)
#' @format An object of class \code{SummarizedExperiment}.
#'
#' @details All coordinates are in hg19.
"example.pdx.counts.anc.se"



#' Subset of pdx.counts.cts.se as a lightweighted example
#'
#' @docType data
#' @description Subset of pdx.counts.cts.se as a lightweighted example, only
#' contains the blood cell types and prostate.
#' @importFrom utils data
#' @usage data(example.pdx.counts.cts.se)
#' @format An object of class \code{SummarizedExperiment}.
#'
#' @details All coordinates are in hg19.
"example.pdx.counts.cts.se"

