% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddPCRclust.R
\name{readFiles}
\alias{readFiles}
\title{Read the csv files from your disk}
\usage{
readFiles(files)
}
\arguments{
\item{files}{The input file(s), specifically csv files. Each file represents a two-dimensional data frame.
Each row within the data frame represents a single droplet, each column the respective intensities per colour channel.}
}
\value{
\item{files}{A data frame composed of the experiment data}
\item{ids}{The file ids, e.g. A01, A02, etc.}
}
\description{
This function reads the raw csv files for ddPCRclust from disk and returns the experiment data.
Please refer to the vignette for more information on how these files need to be formatted.
}
\examples{
# Read files
exampleFiles <- list.files(paste0(find.package('ddPCRclust'), '/extdata'), full.names = TRUE)
files <- readFiles(exampleFiles[1:8])

}
