% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloseq_qc.R
\name{phy_qc}
\alias{phy_qc}
\alias{phy_qc,Recipe-method}
\title{Phyloseq Quality Control Metrics}
\usage{
phy_qc(rec)

\S4method{phy_qc}{Recipe}(rec)
}
\arguments{
\item{rec}{A Recipe or Recipe step.}
}
\value{
A tibble
}
\description{
phy_qc() returns a tibble. It will have information about some important
metrics about the sparsity of the count matrix. The content of the table is
as follows:
\itemize{
\item var_levels: levels of the categorical variable of interest. "all" refers
to all rows of the dataset (without splitting by categorical levels).
\item n: total number of values in the count matrix.
\item n_zero: number of zeros in the count matrix.
\item pct_zero: percentage of zeros in the count matrix.
\item pct_all_zero: percentage of taxa with zero counts in all samples.
\item pct_singletons: percentage of taxa with counts in a single sample.
\item pct_doubletons: percentage of taxa with counts in two samples.
\item count_mean: average of the mean counts per sample.
\item count_min: average of the min counts per sample.
\item count_max: average of the max counts per sample.
}
}
\examples{
data(metaHIV_phy)

## Define Recipe
rec <- recipe(metaHIV_phy, var_info = "RiskGroup2", tax_info = "Species")

phy_qc(rec)
}
