% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{corr_heatmap}
\alias{corr_heatmap}
\alias{corr_heatmap,Recipe-method}
\alias{corr_heatmap,PrepRecipe-method}
\title{Plot otuput of the \code{overlap_df} function as a heatmap.}
\usage{
corr_heatmap(rec, steps = steps_ids(rec, "da"), font_size = 15, type = "all")

\S4method{corr_heatmap}{Recipe}(rec, steps = steps_ids(rec, "da"), font_size = 15, type = "all")

\S4method{corr_heatmap}{PrepRecipe}(rec, steps = steps_ids(rec, "da"), font_size = 15, type = "all")
}
\arguments{
\item{rec}{A \code{Recipe} object.}

\item{steps}{Character vector with step_ids to take in account.}

\item{font_size}{Size of the axis font.}

\item{type}{Indicates whether to use all taxa ("all") or only those that are
differentially abundant in at least one method ("da"). Default as "all".}
}
\value{
heatmap
}
\description{
Plot otuput of the \code{overlap_df} function as a heatmap.
}
\examples{
data(test_prep_rec)

## Running the function returns a UpSet plot ordered by frequency.
corr_heatmap(test_prep_rec)

## If you want to exclude a method for the plot, you can remove it with the
## step parameter. In the following example we eliminate from the graph the
## results of maaslin
corr_heatmap(test_prep_rec, steps = steps_ids(test_prep_rec, "da")[-1])

## corr_heatmap function needs a PrepRecipe. If you pass a a non-prep
## Recipe the output is an error.
data(test_rec)
err <- testthat::expect_error(corr_heatmap(test_rec))
err
}
