% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe-class.R
\name{add_var}
\alias{add_var}
\alias{add_var,Recipe-method}
\alias{add_var,PrepRecipe-method}
\title{Adds variable of interest to the Recipe}
\usage{
add_var(rec, var_info)

\S4method{add_var}{Recipe}(rec, var_info)

\S4method{add_var}{PrepRecipe}(rec, var_info)
}
\arguments{
\item{rec}{A \code{Recipe} object.}

\item{var_info}{A character string of column names corresponding to variables
that will be used in any context.}
}
\value{
A \code{Recipe} object.
}
\description{
Adds variable of interest to the Recipe
}
\examples{
data(metaHIV_phy)

## Define recipe
rec <- recipe(metaHIV_phy)

## add var info
rec <- add_var(rec, var_info = "RiskGroup2")
rec

## add var info to a prep-recipe returns an error
data(test_prep_rec)
err <- testthat::expect_error(
  add_var(test_prep_rec, var_info = "RiskGroup2")
)

err
}
