% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_volcano.R
\name{plot_volcano}
\alias{plot_volcano}
\title{Volcano plot of differentially bound/expressed loci}
\usage{
plot_volcano(
  diff_results,
  fdr_filter_threshold = NULL,
  plot_config = list(),
  label_config = list(),
  highlight = NULL,
  highlight_config = list(),
  label_display = list(),
  save = NULL
)
}
\arguments{
\item{diff_results}{A `DamIDResults` object, as returned by
`differential_binding()` or `differential_accessibility()`.}

\item{fdr_filter_threshold}{Numeric or NULL. If a value (e.g., 0.05) is provided,
the volcano plot will only include loci that have an FDR value less than or
equal to this threshold in at least one replicate of the two conditions
being plotted. This requires that the data was loaded using
`load_data_genes` with `calculate_occupancy_pvals = TRUE`, which generates the
necessary `_FDR` columns. If `NULL` (default), no FDR-based filtering is
performed.}

\item{plot_config}{List. Names to override plot details (title, axes, size,
colours, etc); see details.
\itemize{
  \item \code{title}, \code{xlab}, \code{ylab} (character)
  \item \code{ystat} (character): The column name from `analysisTable(diff_results)`
    to use for the y-axis (e.g., "minuslogp" or "B"). Default is "B".
  \item \code{base_size} (integer): ggplot theme base font size.
  \item \code{sig_colour}, \code{nonsig_colour} (colours)
  \item \code{sig_alpha}, \code{sig_size}: alpha and size for significant points.
  \item \code{nonsig_alpha}, \code{nonsig_size}: alpha and size for non-significant points.
}}

\item{label_config}{List. Fine-grained label controls; if missing or `NULL`,
no labels are added (see details).
\itemize{
  \item \code{genes}: character vector to restrict labels to a subset
    (default: label all significant).
  \item \code{label_size}: label size (numeric).
  \item \code{clean_names}: logical; if `TRUE`, applies regex filtering to labels.
  \item \code{names_clean}, \code{names_clean_extra}: regex to exclude from labels
    when \code{clean_names} is `TRUE`.
  \item \code{max_overlaps}: integer; maximum ggrepel overlaps. (default: 10)
}}

\item{highlight}{List. A simple list where each element is a character vector
of genes/loci to highlight. Each element of this list will correspond to a
separate highlight group. If `NULL`, no highlight overlays are drawn.}

\item{highlight_config}{List. Additional highlight configuration options,
applied consistently across all highlight groups. If missing or `NULL`,
defaults are used.
\itemize{
  \item \code{alpha}: Numeric; transparency for highlight points (default: 1).
  \item \code{size}: Numeric; size for highlight points (default: 2).
  \item \code{label}: Logical; if `TRUE`, labels are added for all highlight groups (default: `FALSE`).
  \item \code{colour}: A list of colours, where each element corresponds to a highlight
    group in the `highlight` list. If not specified or not enough colours are
    provided, a default hue palette is used.
  \item \code{label_size}: Numeric; label size (default: 4).
  \item \code{max_overlaps}: Integer; maximum ggrepel overlaps for highlight labels (default: 10).
  \item \code{sig_labels_only}: Logical; whether to only label significant loci in the set
  \item \code{legend}: Logical; whether to draw a plot legend for the highlight groups (default: TRUE).
  \item \code{legend_inside}: Logical; whether to draw the plot legend for
    the highlight groups inside the plot (default: TRUE).
  \item \code{legend_inside_pos}: String, either 'r' (right) or 'l' (left).
    Presets for internal legend position in the bottom right or left corners
    of the plot.  (default: 'r')
  \item \code{legend_position_override}: Numeric. Manual override for internal
    legend positioning when not set to the default, NULL.
  \item \code{legend_justification_override}: Numeric. Manual override for internal
    legend justification when not set to the default, NULL.
  \item \code{label_fill}: logical; if `TRUE`, uses `geom_label_repel`, else `geom_text_repel` (default: FALSE)
  \item \code{text_col}: logical; if `TRUE`, text is coloured as per points, else black (default: FALSE)
  \item \code{text_luminosity}: Numeric (0-100).  When using `text_col`, setting
    a non-zero value will darken the luminosity of the highlight colour on text
    labels for increased contrast. 0 = no change; 100 = black. (default: 0)
}}

\item{label_display}{List. Additional label display options for sampling dense
labels in all groups.  Uses KNN-based sampling to optimise display when not
NULL.
\itemize{
  \item \code{scale}: Logical; if \code{TRUE}, labelled coordinate data are centred
    and scaled (using \code{scale(center = TRUE, scale = TRUE)}) before
    sampling.  Note: this does not affect plotted values. (default: \code{TRUE}).
  \item \code{r}: Numeric or \code{"auto"}; the sampling exclusion radius. If \code{"auto"},
     \code{r} is set to the median distance to the \code{k_for_r}-th
     nearest neighbour across all points. A smaller \code{r} keeps more
     points. (Default: 0.2).
  \item \code{k_search}: Integer; maximum number of neighbours to find in the initial KNN search. Must be greater than or equal to both \code{k} and \code{k_for_r} (default: 30).
  \item \code{k_priority}: Integer; number of neighbours used to infer the
    isolation priority score. Must be less than or equal to \code{k_search} (default: 30).
  \item \code{k_for_r}: Integer; which neighbour to use for the
    \code{"auto"} \code{r} calculation (default: 30).
}}

\item{save}{List or `NULL`. Controls saving the plot to a file.
If `NULL`, `FALSE`, or `0`, the plot is not saved.
If a `list`, it specifies saving parameters:
\itemize{
  \item \code{filename} (character): The path and base name for the output file
    (e.g., "my_volcano_plot"). If not specified, a default is used.
  \item \code{format} (character): File format ("pdf", "svg", or "png").
    Default is "pdf".
  \item \code{width} (numeric): Width of the plot in inches. Default is 5.
  \item \code{height} (numeric): Height of the plot in inches. Default is 4.
}}
}
\value{
A `ggplot` object
}
\description{
Creates a volcano plot from the results of a differential analysis. The plot
shows the log-fold change against a measure of statistical significance.
The function offers extensive customisation for point appearance, gene
labelling, and highlighting specific groups of loci.
}
\examples{
# Helper function to create a sample DamIDResults object
.generate_example_results <- function() {
    mock_genes_gr <- GenomicRanges::GRanges(
        seqnames = S4Vectors::Rle("2L", 7),
        ranges = IRanges::IRanges(
            start = c(1000, 2000, 3000, 5000, 6000, 7000, 8000),
            end = c(1500, 2500, 3500, 5500, 6500, 7500, 20000000)
        ),
        gene_id = c("FBgn001", "FBgn002", "FBgn003", "FBgn004", "FBgn005", "FBgn006", "FBgn007"),
        gene_name = c("ap", "dpr1", "side", "mav", "geneE", "geneF", "LargeTestGene")
    )
    data_dir <- system.file("extdata", package = "damidBind")
    loaded_data <- load_data_peaks(
        binding_profiles_path = data_dir,
        peaks_path = data_dir,
        ensdb_genes = mock_genes_gr,
        quantile_norm = TRUE
    )
    diff_results <- differential_binding(
        loaded_data,
        cond = c("L4 Neurons" = "L4",
                 "L5 Neurons" = "L5")
    )
    return(diff_results)
}
diff_results <- .generate_example_results()

# Generate a default volcano plot
plot_volcano(diff_results)

}
