% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareProteomeByUniProtWS.R
\name{prepareProteomeByUniProtWS}
\alias{prepareProteomeByUniProtWS}
\title{Prepare a Proteome object for background building}
\usage{
prepareProteomeByUniProtWS(UniProt.ws, fasta, species = "unknown")
}
\arguments{
\item{UniProt.ws}{An object of \code{\link{UniProt.ws}}.}

\item{fasta}{A fasta file name or an object of \code{\link{AAStringSet}}.}

\item{species}{An character vector of length (1) to designate the species
of the proteome}
}
\value{
An object of Proteome which contain protein sequence information.
}
\description{
Create an object of \code{\link{Proteome}} Class by query
the UniProt database of an organism of a given species' scientific name,
or by using peptide sequences in a fasta file or in an AAStringSet object.
}
\examples{
if(interactive()){
   library(UniProt.ws)
   availableUniprotSpecies("Drosophila melanogaster")
   UniProt.ws <- UniProt.ws(taxId=7227)
   proteome <- prepareProteomeByUniProtWS(UniProt.ws, species="Drosophila melanogaster")
 }
}
\seealso{
\code{\link{formatSequence}}, \code{\link{buildBackgroundModel}}
}
\author{
Jianhong Ou
}
\keyword{misc}
