% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagLogo.R
\name{getGroupingSymbol}
\alias{getGroupingSymbol}
\title{Get character symbols for grouped amino acids}
\usage{
getGroupingSymbol(groupingScheme = ls(envir = cachedEnv))
}
\arguments{
\item{groupingScheme}{A character vector of length 1, determining the character
symbols used to represent amino acids grouped by their physical and chemical
properties. The available \code{groupingScheme} are "no","bulkiness_Zimmerman",
"hydrophobicity_KD", "hydrophobicity_HW", "isoelectric_point_Zimmerman",
"contact_potential_Maiorov", "chemistry_property_Mahler", "consensus_similarity_SF", 
"volume_Bigelow", "structure_alignments_Mirny", "polarity_Grantham", 
"sequence_alignment_Dayhoff", "bulkiness_Zimmerman_group", "hydrophobicity_KD_group",
"hydrophobicity_HW_group", "charge_group", "contact_potential_Maiorov_group",
"chemistry_property_Mahler_group", "consensus_similarity_SF_group", 
"volume_Bigelow_group", "structure_alignments_Mirny_group", "polarity_Grantham_group",  
"sequence_alignment_Dayhoff_group", and "custom". If "custom" is used, users 
must define a grouping scheme using a list containing sublists named as "color",
"symbol" and "group" using the function \code{\link{addScheme}}. No grouping 
was applied for the first 12 schemes.}
}
\value{
A named character vector of character symbols if grouping is applied;
otherwise NULL.
}
\description{
Get character symbols for grouped amino acids
}
\examples{
getGroupingSymbol("polarity_Grantham_group")
}
\seealso{
{\code{\link{addScheme}}}
}
\author{
Jianhong Ou, Haibo Liu
}
\keyword{internal}
