% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotInitialGuess.R
\name{plotInitialGuess}
\alias{plotInitialGuess}
\title{Plot preliminary classification from initialGuess}
\usage{
plotInitialGuess(
  x,
  IG = NULL,
  fit = NULL,
  type = c("both", "full", "truncated")
)
}
\arguments{
\item{x}{The score (ie. debris score, doublet score, etc.) to be used for
predicting each event's label (eg. "doublet" vs. "cell").}

\item{IG}{If NULL, the function \code{initialGuess} is used to fit a mixture
of normal distributions. Otherwise, a numeric vector can be passed to the 
function that contains the fitted values.}

\item{fit}{If left blank or NULL, the best fit as determined by BIC will be
plotted. Otherwise, a numeric value of 1, 2, or 3 can be be selected to 
plot single normal fit, mixture of two normals, or the mixture of three
normals as fit by \code{initialGuess}.}

\item{type}{Type of graph to be plotted. If 'truncated' is selected, only 
half of the first normal distribution will be plotted. If 'both' is 
selected, both the truncated and full plot will be plotted.}
}
\value{
A histogram that shows the score with the mixture of normal 
distributions overlayed.
}
\description{
Plot preliminary classification from initialGuess
}
\examples{
data("raw_data", package = "CATALYST")
sce <- readCytof(raw_data, beads = "Beads", viability = c("cisPt1", "cisPt2"))
sce <- initialDoublet(sce)
plotInitialGuess(scores(sce, "doublet"), type = "both")
plotInitialGuess(scores(sce, "doublet"), type = "truncated")

}
