% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytofQCreport.R
\name{cytofQCreport}
\alias{cytofQCreport}
\title{Generate a cytofQC report}
\usage{
cytofQCreport(x, outDir, sampName, runUMAP = TRUE, ...)
}
\arguments{
\item{x}{A SingleCellExperiment object generated by \code{\link{labelQC}}.}

\item{outDir}{The output directory (currently required).}

\item{sampName}{Basename of the output HTML file (if not provided, same as
\code{outDir}).}

\item{runUMAP}{Logical value indicating whether or not to include a UMAP plot
in the report. This plot can be beneficial for diagnostic purposes, but is
time-consuming to generate.}

\item{...}{Additions arguments that may be passed to the function.}
}
\value{
If successful, returns \code{TRUE} silently and generates the
  specified QC report.
}
\description{
Generate a cytofQC report
}
\examples{
data("raw_data", package = "CATALYST")
x <- readCytof(raw_data, beads = "Beads", viability = c("cisPt1", "cisPt2"))
x <- labelQC(x, n = 500)
tmp <- tempdir()
cytofQCreport(x, tmp, 'example')

}
