% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CyData.R
\name{CyData}
\alias{CyData}
\alias{CyData-class}
\alias{markernames}
\alias{markernames,CyData-method}
\alias{cellAssignments}
\alias{cellInformation}
\alias{intensities}
\alias{cellIntensities}
\alias{getCenterCell}
\alias{[,CyData,ANY,ANY,ANY-method}
\alias{[<-,CyData,ANY,ANY,CyData-method}
\alias{cbind,CyData-method}
\alias{show,CyData-method}
\title{CyData class and methods}
\description{
The CyData class is derived from the \linkS4class{SingleCellExperiment} class.
It is intended to store the cell counts for each group of cells (rows) for each sample (columns).
Groups are intended to be hyperspheres (see \code{\link{countCells}}) but could also be arbitrary clusters of cells.
It also stores the median intensities for each group and the identity of cells in the groups, parallel to the rows.
}
\details{
CyData objects should not be created directly by users.
The class has some strict validity conditions that are not easily satisfied by manual construction.
Users should rely on functions like \code{\link{prepareCellData}} and \code{\link{countCells}} to create the objects.
An overview of the CyData class and the available methods.
}
\section{Getter functions for group-level data}{

In the following code chunks, \code{x} or \code{object} are CyData objects.
\code{mode} is a string specifying the types of markers that should be returned;
this defaults to only those markers that are used in \code{\link{prepareCellData}},
but can also return the unused markers or all of them.

\itemize{
\item \code{intensities(x, mode=c("used", "all", "unused")} 
returns a numeric matrix of intensities for each group of cells (rows) and markers (columns).
Rows of the output matrix correspond to rows of \code{x}.
Values are returned for the markers specified by \code{mode} (see above).
\item \code{cellAssignments(x)} returns a list of integer vectors, 
where each vector corresponds to a row of \code{x} and contains the indices of the cells in that group.
Indices refer to columns of \code{cellIntensities(x)}.
\item \code{markernames(object, mode=c("used", "all", "unused"))}
returns a character vector of the marker names, depending on \code{mode} (see above).
\item \code{getCenterCell(x)} returns the index of the cell used at the center of each hypersphere.
}
}

\section{Getter functions for cell-level data}{

In the following code chunks, \code{x} is a CyData object and \code{mode} is as previously described.

\itemize{
\item \code{cellIntensities(x, mode=c("used", "all", "unused"))} 
returns a numeric matrix of intensities for each marker (row) and cell (column).
\item \code{cellInformation(x)} returns a \linkS4class{DataFrame} with one row per cell.
The \code{sample} field specifies the sample of origin for each cell,
while the \code{cell} field specifies the original row index of that cell in its original sample.
}
}

\section{Subsetting}{

The subsetting and combining behaviour of CyData objects is mostly the same as that of \linkS4class{SingleCellExperiment} objects.
The only difference is that subsetting or combining CyData objects by column is not advisable.
Indeed, attempting to do so will result in a warning from the associated methods.
This is because the columns are usually not independent in contexts involving clustering cells across multiple samples.
If a sample is to be removed, it is more appropriate to do so in the function that generates the CyData object (usually \code{\link{prepareCellData}}).
}

\examples{
example(countCells, echo=FALSE)

markernames(cnt)
head(intensities(cnt))
head(cellAssignments(cnt))

}
\author{
Aaron Lun
}
