% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyto_filter.R
\name{phytoFilter}
\alias{phytoFilter}
\title{gates out and assign indicators to phytoplankton cells based on 
the expression of  measured cell complexity channels.}
\usage{
phytoFilter(
  flowfile,
  pig_channels = NULL,
  com_channels = NULL,
  ph = 0.05,
  proportion = 0.8
)
}
\arguments{
\item{flowfile}{flowframe after debris are removed.}

\item{pig_channels}{flowcytometer channels measuring cell pigments.}

\item{com_channels}{flowcytometer channels measuring cell complexity.}

\item{ph}{maximum peak height to be ignored. This allows ignoring of tiny 
peaks that could affect the gating process.}

\item{proportion}{proportion of cell count to be returned.}
}
\value{
object of class \link{PhytopFilter} containing; \itemize{
\item \strong{fullflowframe -} flowframe containing all phytoplankton cells 
                               with added columns indicating cluster
\item \strong{flowframe_proportion -} a part of fullflowframe containing 
                                      proportion of cell count.
\item \strong{clusters_proportion -} proportion of cells in each cluster
\item \strong{particles_per_cluster -} number of particles per cluster
\item \strong{Cluster_ind -} indicator for each cluster
\item \strong{gated_channels -} channels with multiple peaks
}
}
\description{
This function takes in a flowframe with debris removed and 
             identifies the different phytoplankton cell population 
             based on cell pigmentation and/or
             complexity.
}
\details{
The function uses the \code{\link[flowDensity]{getPeaks}} and
         \code{\link[flowDensity]{deGate}} functions in the 
         \emph{flowDensity} package to
         identify peaks and identify cut-off points between these peaks.
}
\examples{
 flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, 
                               emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
                      c('SSC.W', 'TIME'))
cells_nonmargin <- cellMargin(flowframe = flowfile_logtrans, 
                              Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
cells_nodebris <- debrisNc(flowframe = reducedFlowframe(cells_nonmargin),
                            ch_chlorophyll = "RED.B.HLin",
                            ch_p2 = "YEL.B.HLin",
                            ph = 0.05)
phytoFilter(flowfile = reducedFlowframe(cells_nodebris),
              pig_channels = c("RED.B.HLin", "YEL.B.HLin", "RED.R.HLin"),
              com_channels = c("FSC.HLin", "SSC.HLin"))



}
