% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctsGE.R
\name{readTSGE}
\alias{readTSGE}
\title{Read and merge a set of files containing gene expression data}
\usage{
readTSGE(files, path = NULL, columns = c(1, 2), labels = NULL,
  desc = NULL, ...)
}
\arguments{
\item{files}{character vector of filenames,
or alternative a named list of tables for each time point.}

\item{path}{character string giving the directory containing the files.
The default is the current working directory.}

\item{columns}{numeric vector stating which two columns contain the tag
names and counts, respectively}

\item{labels}{character vector giving short names to associate with the
libraries.}

\item{desc}{character vector with genes description (annotation),default to
NULL
Defaults to the file names.}

\item{...}{other are passed to read.delim}
}
\value{
A list with four objects:
 \enumerate{\item expression matrix
            \item samples names
            \item tags - genes name
            \item timePoints - number of time points}
}
\description{
Reads and merges a set of text files containing normalized gene expression
data
}
\details{
As input, the ctsGE package expects normalized expression table,
where rows are genes and columns are samples
Each file is assumed to contained digital gene expression data for one
sample (or library), with transcript or gene identifiers in the first
column and expression values in the second column.
Transcript identifiers are assumed to be unique and not repeated in any one
file.
By default, the files are assumed to be tab-delimited and to contain column
   headings.
The function forms the union of all transcripts and creates one big table
with zeros where necessary.
When reading the normalized expression values the function check whether
there are rows that their median absolute deviation (MAD) value equal to zero
and remove these rows. This step is important in order to continue to the
next step of indexing the data.
The function will output a message of how many genes were remove.
}
\examples{
## Read all .txt files from current working directory
data_dir <- system.file("extdata", package = "ctsGE")
files <- dir(path=data_dir,pattern = "\\\\.xls$")

# reading only 2000 genes
rts <- readTSGE(files, path = data_dir,
 labels = c("0h","6h","12h","24h","48h","72h"), skip = 10625 )
}

