% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctsGEShinyApp.R
\name{ctsGEShinyApp}
\alias{ctsGEShinyApp}
\title{GUI for interactive exploration of gene expression data.}
\usage{

ctsGEShinyApp(rts, min_cutoff = 0.5, max_cutoff = 0.7, mad.scale = TRUE,
  title = NULL)

}
\arguments{
\item{rts}{list of an expression data that made by readTSGE}

\item{min_cutoff}{A numeric the lower limit range to calculate the optimal
cutoff for the data, default to 0.5
\emph{See \code{\link{PreparingTheIndexes}}}.}

\item{max_cutoff}{A numeric the upper limit range to calculate the optimal
cutoff for the data, default to 0.7
\emph{See \code{\link{PreparingTheIndexes}}}.}


\item{mad.scale}{A boolean defaulting to TRUE as to what method of scaling
to use.
 Default median-base scaling. FALSE, mean-base scaling}

\item{title}{Character, the title at the header panel. default to NULL.}
}
\value{
Creates a shiny application and opens a shinyapp.io web page
}
\description{
Produce and launch Shiny app for interactive exploration of gene expression
 data.
For more information about shiny apps \cite{http://shiny.rstudio.com/}
}
\details{
The `ctsGEShinyApp` function takes the ctsGE object
and opens an html page as a GUI. On the web page, the user
chooses the profile to visualize and the number of clusters (k parameter for
 K-means) to show. The line graph of the profile separated into the clusters
 will show in the main panel, and a list of the genes and their expressions
 will also be available. The tables and figures can be downloaded.
}
\examples{

\dontrun{
data_dir <- system.file("extdata", package = "ctsGE")
files <- dir(path=data_dir,pattern = "\\\\.xls$")
rts <- readTSGE(files, path = data_dir,
labels = c("0h","6h","12h","24h","48h","72h") )
ctsGEShinyApp(rts)}


}
\seealso{
shiny::ShinyApp
}

