% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRuleSet1Scores.R
\name{getRuleSet1Scores}
\alias{getRuleSet1Scores}
\title{Calculate on-target sgRNA activity scores for Cas9 using Rule Set 1}
\usage{
getRuleSet1Scores(sequences)
}
\arguments{
\item{sequences}{Character vector of 30bp sequences needed for
Rule Set 1 scoring, see details below.}
}
\value{
\strong{getRuleSet1Scores} returns a data.frame with \code{sequence} 
    and \code{score} columns. The Rule Set 1 score takes on a value between 0
    and 1. A higher score indicates higher knockout efficiency.
}
\description{
Calculate on-target sgRNA activity scores for
    CRISPR/Cas9-induced knockout using the Rule Set 1 scoring method.
    The Rule Set 1 algorithm was an early on-target efficiency method
    developed by the Doench lab.
}
\details{
The input sequences for Rule Set 1 scoring require 4 nucleotides
    upstream of the protospacer sequence, the protospacer sequence
    itself (23 nucleotides) and 3 nucleootides downstream of the protospacer
    sequence, for a total of 30 nucleotides: [4nt][20nt-spacer][NGG][3nt].
    Note that a canonical PAM sequence (NGG) is required for Rule Set 1.
}
\examples{

flank5 <- "ACCT" #4bp
spacer <- "ATCGATGCTGATGCTAGATA" #20bp
pam    <- "AGG" #3bp 
flank3 <- "TTG" #3bp
input  <- paste0(flank5, spacer, pam, flank3) 
results <- getRuleSet1Scores(input)

}
\references{
Doench, John G., et al. Rational design of highly active sgRNAs
    for CRISPR-Cas9–mediated gene inactivation. Nat Biotech 32, 1262-1267 (2014).
    \url{https://doi.org/10.1038/nbt.3026}.
}
\author{
Jean-Philippe Fortin
}
