% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCRISPRscanScores.R
\name{getCRISPRscanScores}
\alias{getCRISPRscanScores}
\title{Calculate on-target sgRNA activity scores for Cas9 using CRISPRscan}
\usage{
getCRISPRscanScores(sequences)
}
\arguments{
\item{sequences}{Character vector of 35bp sequences needed for
CRISPRscan scoring, see details below.}
}
\value{
\strong{getCRISPRscanScores} returns a data.frame with \code{sequence} 
    and \code{score} columns. The CRISPRscan score takes on a value between 0
    and 1. A higher score indicates higher knockout efficiency.
}
\description{
Calculate on-target sgRNA activity scores for
    CRISPR/Cas9-induced knockout using the CRISPRscan scoring method.
    The method is also know as the Moreno-Mateos score. 
    The CRISPRscan  algorithm was trained using in vitro transcription
    of sgRNAs using a T7 promoter, and might therefore be 
    suboptimal to predict sgRNA activity when expressed from U6 promoter.
}
\details{
The input sequences for Rule Set 1 scoring require 6 nucleotides
    upstream of the protospacer sequence, the protospacer sequence
    itself (23 nucleotides) and 6 nucleootides downstream of the protospacer
    sequence, for a total of 35 nucleotides: [6nt][20nt-spacer][NGG][6nt].
    Note that a canonical PAM sequence (NGG) is required for CRISPRscan.
}
\examples{

flank5 <- "ACCTGG" #6bp
spacer <- "ATCGATGCTGATGCTAGATA" #20bp
pam    <- "AGG" #3bp 
flank3 <- "TTGAGC" #6bp
input  <- paste0(flank5, spacer, pam, flank3) 
results <- getCRISPRscanScores(input)

}
\references{
Moreno-Mateos MA, et al. CRISPRscan: designing highly efficient
    sgRNAs for CRISPR-Cas9 targeting in vivo. Nature methods. 2015 Oct;12(10):982-8.
}
\author{
Jean-Philippe Fortin
}
