% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAzimuthScores.R
\name{getAzimuthScores}
\alias{getAzimuthScores}
\title{Calculate on-target sgRNA activity scores for Cas9 using Azimuth}
\usage{
getAzimuthScores(sequences, fork = FALSE)
}
\arguments{
\item{sequences}{Character vector of 30bp sequences needed for
Azimuth scoring, see details below.}

\item{fork}{Set to \code{TRUE} to preserve changes to the R
configuration within the session.}
}
\value{
\strong{getAzimuthScores} returns a data.frame with \code{sequence} 
    and \code{score} columns. The Azimuth score takes on a value between 0
    and 1. A higher score indicates higher knockout efficiency.
}
\description{
Calculate on-target sgRNA activity scores for
    CRISPR/Cas9-induced knockout using the Azimuth scoring method.
    The Azimuth algorithm is an improvement upon the commonly-used
    'Rule Set 2', also developed by the Doench lab.
}
\details{
The input sequences for Azimuth scoring require 4 nucleotides
    upstream of the protospacer sequence, the protospacer sequence
    itself (23 nucleotides) and 3 nucleootides downstream of the protospacer
    sequence, for a total of 30 nucleotides: [4nt][20nt-spacer][NGG][3nt].
    Note that a canonical PAM sequence (NGG) is required for Azimuth.
}
\examples{
if (interactive()){
flank5 <- "ACCT" #4bp
spacer <- "ATCGATGCTGATGCTAGATA" #20bp
pam    <- "AGG" #3bp 
flank3 <- "TTG" #3bp
input  <- paste0(flank5, spacer, pam, flank3) 
results <- getAzimuthScores(input)
}

}
\references{
Doench, J., Fusi, N., Sullender, M. et al. Optimized sgRNA design to
    maximize activity and minimize off-target effects of CRISPR-Cas9.
    Nat Biotechnol 34, 184–191 (2016).
    \url{https://doi.org/10.1038/nbt.3437}.
}
\author{
Jean-Philippe Fortin
}
