% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addRepeats.R
\name{removeRepeats}
\alias{removeRepeats}
\alias{removeRepeats,GuideSet-method}
\alias{removeRepeats,PairedGuideSet-method}
\alias{removeRepeats,NULL-method}
\title{Remove \linkS4class{GuideSet} gRNAs that overlap repeat elements}
\usage{
removeRepeats(object, ...)

\S4method{removeRepeats}{GuideSet}(object, gr.repeats = NULL, ignore.strand = TRUE)

\S4method{removeRepeats}{PairedGuideSet}(object, gr.repeats = NULL, ignore.strand = TRUE)

\S4method{removeRepeats}{NULL}(object)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{gr.repeats}{A \linkS4class{GRanges} object containing
repeat elements regions.}

\item{ignore.strand}{Should gene strand be ignored when annotating?
TRUE by default.}
}
\value{
\code{object} filtered for spacer sequences not overlapping
    any repeat elements. An \code{inRepeats} column is also appended in
    \code{mcols(object)}.
}
\description{
Remove \linkS4class{GuideSet} gRNAs that overlap repeat
    elements.
}
\examples{
data(guideSetExample, package="crisprDesign")
data(grRepeatsExample, package="crisprDesign")
guideSet <- removeRepeats(guideSetExample,
                          gr.repeats=grRepeatsExample)

}
\seealso{
\code{link{addRepeats}}.
}
\author{
Jean-Philippe Fortin, Luke Hoberecht
}
