% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{grListExample}
\alias{grListExample}
\title{Example of a \linkS4class{TxDb} object converted to a
    \linkS4class{GRangesList}}
\format{
Named \linkS4class{GRangesList} with 7 elements:
    \code{transcripts}, \code{exons},
    \code{cds}, \code{fiveUTRs}, \code{threeUTRs}, \code{introns}
    and \code{tss}.
}
\usage{
data(grListExample, package="crisprDesign")
}
\description{
Example of a \linkS4class{TxDb} object converted to a
    \linkS4class{GRangesList} object for human gene
    IQSEC3 (ENSG00000120645).
}
\details{
The full human transcriptome \linkS4class{TxDb} object was
    obtained from the Ensembl 104 release using the \code{\link{getTxDb}}
    function and converted to a \linkS4class{GRangesList} object using the 
    \code{\link{TxDb2GRangesList}} function and subsequently subsetted
    to only contain the IQSEC3 gene (ENSG00000120645) located
    at the start of chr12 in the human genome (hg38 build).
}
\keyword{datasets}
