% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addSpacerAlignments.R
\name{addSpacerAlignments}
\alias{addSpacerAlignments}
\alias{addSpacerAlignmentsIterative}
\alias{addSpacerAlignmentsIterative,GuideSet-method}
\alias{addSpacerAlignmentsIterative,PairedGuideSet-method}
\alias{addSpacerAlignmentsIterative,NULL-method}
\alias{addSpacerAlignments,GuideSet-method}
\alias{addSpacerAlignments,PairedGuideSet-method}
\alias{addSpacerAlignments,NULL-method}
\alias{getSpacerAlignments}
\title{Functions for finding and characterizing on- and off-targets of
    spacer sequences.}
\usage{
addSpacerAlignments(object, ...)

addSpacerAlignmentsIterative(object, ...)

\S4method{addSpacerAlignmentsIterative}{GuideSet}(
  object,
  aligner = c("bowtie", "bwa", "biostrings"),
  colname = "alignments",
  addSummary = TRUE,
  txObject = NULL,
  tssObject = NULL,
  custom_seq = NULL,
  aligner_index = NULL,
  bsgenome = NULL,
  n_mismatches = 0,
  all_alignments = FALSE,
  canonical = TRUE,
  standard_chr_only = FALSE,
  both_strands = TRUE,
  anchor = c("cut_site", "pam_site"),
  annotationType = c("gene_symbol", "gene_id"),
  tss_window = NULL,
  alignmentThresholds = c(n0 = 5, n1 = 100, n2 = 100, n3 = 1000, n4 = 1000)
)

\S4method{addSpacerAlignmentsIterative}{PairedGuideSet}(
  object,
  aligner = c("bowtie", "bwa", "biostrings"),
  colname = "alignments",
  addSummary = TRUE,
  txObject = NULL,
  tssObject = NULL,
  custom_seq = NULL,
  aligner_index = NULL,
  bsgenome = NULL,
  n_mismatches = 0,
  all_alignments = FALSE,
  canonical = TRUE,
  standard_chr_only = FALSE,
  both_strands = TRUE,
  anchor = c("cut_site", "pam_site"),
  annotationType = c("gene_symbol", "gene_id"),
  tss_window = NULL,
  alignmentThresholds = c(n0 = 5, n1 = 100, n2 = 100, n3 = 1000, n4 = 1000)
)

\S4method{addSpacerAlignmentsIterative}{NULL}(object)

\S4method{addSpacerAlignments}{GuideSet}(
  object,
  aligner = c("bowtie", "bwa", "biostrings"),
  colname = "alignments",
  addSummary = TRUE,
  txObject = NULL,
  tssObject = NULL,
  custom_seq = NULL,
  aligner_index = NULL,
  bsgenome = NULL,
  n_mismatches = 0,
  n_max_alignments = 1000,
  all_alignments = TRUE,
  canonical = TRUE,
  standard_chr_only = FALSE,
  both_strands = TRUE,
  anchor = c("cut_site", "pam_site"),
  annotationType = c("gene_symbol", "gene_id"),
  tss_window = NULL
)

\S4method{addSpacerAlignments}{PairedGuideSet}(
  object,
  aligner = c("bowtie", "bwa", "biostrings"),
  colname = "alignments",
  addSummary = TRUE,
  txObject = NULL,
  tssObject = NULL,
  custom_seq = NULL,
  aligner_index = NULL,
  bsgenome = NULL,
  n_mismatches = 0,
  n_max_alignments = 1000,
  all_alignments = FALSE,
  canonical = TRUE,
  standard_chr_only = FALSE,
  both_strands = TRUE,
  anchor = c("cut_site", "pam_site"),
  annotationType = c("gene_symbol", "gene_id"),
  tss_window = NULL
)

\S4method{addSpacerAlignments}{NULL}(object)

getSpacerAlignments(
  spacers,
  aligner = c("bowtie", "bwa", "biostrings"),
  custom_seq = NULL,
  aligner_index = NULL,
  bsgenome = NULL,
  n_mismatches = 0,
  n_max_alignments = 1000,
  all_alignments = TRUE,
  crisprNuclease = NULL,
  canonical = TRUE,
  standard_chr_only = FALSE,
  both_strands = TRUE
)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{aligner}{Which genomic alignment method should be used?
 Must be one of "bowtie", "bwa", and "biostrings".
"bowtie" by default. Note that "bwa" is not availble for 
 Windows machines.}

\item{colname}{String specifying the columm name storing the alignments
in \code{mcols(guideSet)}. "alignments" by default.}

\item{addSummary}{Should summary columns be added to \code{guideSet}?
TRUE by default.}

\item{txObject}{A \linkS4class{TxDb} object or a \linkS4class{GRangesList}
object obtained using \code{\link{TxDb2GRangesList}} for annotating
on-target and off-target alignments using gene annotation.}

\item{tssObject}{A \linkS4class{GRanges} object specifying TSS coordinates.}

\item{custom_seq}{Optional string specifying the target DNA sequence for
the search space. This will limit the off-target
search to the specified custom sequence.}

\item{aligner_index}{String specifying bowtie or BWA index.
Must be provided when \code{aligner} is either \code{"bowtie"} or
\code{"bwa"}.}

\item{bsgenome}{A \linkS4class{BSgenome} object from which to extract
sequences if a \linkS4class{GRanges} object is provided as input.}

\item{n_mismatches}{Maximum number of mismatches permitted between guide RNA
and genomic DNA.}

\item{all_alignments}{Should all all possible alignments be returned?
FALSE by default.}

\item{canonical}{\code{TRUE} returns only those alignments having canonical
PAM sequences; \code{FALSE} returns alignments having canonical or
noncanonical PAM sequences; \code{NA} returns all alignments regardless
of their PAM sequence.}

\item{standard_chr_only}{Should only standard chromosomes be considered?
If \code{TRUE}, the function will attempt to remove
scaffold sequences automatically. \code{FALSE by default}.}

\item{both_strands}{When \code{custom_seq} is specified,
should both strands be considered? TRUE by default.}

\item{anchor}{The position within the protospacer as determined by
\linkS4class{CrisprNuclease} to use when annotating with overlapping
gene regions.}

\item{annotationType}{Gene identifier to return when annotating alignments
with gene and/or promoter overlaps. Corresponding \code{txObject} or
\code{tssObject} argument must have mcol column name for selected type.}

\item{tss_window}{Window size of promoters upstream of gene TSS to search
for overlap with spacer sequence. Must be a numeric vector of length 2:
upstream limit and downstream limit. Default is \code{c(-500, 500)},
which includes 500bp upstream and downstream of the TSS.}

\item{alignmentThresholds}{Named numeric vector of the maximum on-target
alignments tolerated for \code{\link{addSpacerAlignmentsIterative}}.
Thresholds not provided will take default values.}

\item{n_max_alignments}{Maximum number of alignments to report by bowtie 
for each spacer. Effectively set to \code{Inf} when \code{allPossible}
is \code{TRUE}.}

\item{spacers}{Character vector of gRNA spacer sequences.
All sequences must be equal in length.}

\item{crisprNuclease}{A \linkS4class{CrisprNuclease} object.}
}
\value{
\code{\link{getSpacerAlignments}} returns a \linkS4class{GRanges} 
    object storing spacer alignment data, including genomic coordinates, 
    spacer and PAM sequences, and position of mismatches relative to
    \code{pam_site}.

\code{\link{addSpacerAlignments}} is similar to 
    \code{\link{getSpacerAlignments}}, with the addition of adding the 
    alignment data to a list-column in \code{mcols(guideSet)} specified
    by \code{colname}.

\code{\link{addSpacerAlignmentsIterative}} is similar to
    \code{\link{addSpacerAlignments}}, except that it avoids finding 
    alignments for spacer sequences that have a large number of on-targets
    and/or off-targets to speed up the off-target search. The parameters
    \code{n0_max}, \code{n1_max} and \code{n2_max} specify the maximum
    number of on-targets (n0) and off-targets
    (n1 for 1-mismatch off-targets, and n2 for 2-mismatch off-targets) 
    tolerated before the algorithm stops finding additional off-targets
    for spacer sequences that exceed those quotas.
}
\description{
Functions for finding and characterizing on- and off-targets of
    spacer sequences.
}
\details{
The columns stored in \code{mcols(guideSet)[["alignments"]]} are:

\itemize{
\item \code{spacer} Spacer sequence of the query gRNA.
\item \code{protospacer} Protospacer sequence in the target DNA.
\item \code{pam} PAM sequence.
\item \code{pam_site} PAM site of the found protospacer.
\item \code{n_mismatches} Integer value specifying the number
    of nucleotide mismatches between the gRNA spacer sequence 
    and the protospacer sequence found in the genome or custom sequence.
\item \code{canonical} Whether the PAM sequence of the found protospacer
    sequence is canonical.
\item \code{cute_site} Cut site of the found protospacer.
}

The following columns are also stored when a \code{txObject} is provided:

\itemize{
\item \code{cds} Character vector specifying gene names of CDS overlapping
    the found protospacer sequence.
\item \code{fiveUTRs} Character vector specifying gene names of 5'UTRs
    overlapping the found protospacer sequence.
\item \code{threeUTRs} Character vector specifying gene names of 3'UTRs
    overlapping the found protospacer sequence.
\item \code{exons} Character vector specifying gene names of exons
    overlapping the found protospacer sequence.
\item \code{introns} Character vector specifying gene names of introns
    overlapping the found protospacer sequence.
\item \code{intergenic} Character vector specifying the nearest gene when
    the found protospacer sequence is not located in a gene.
\item \code{intergenic_distance} Distance in base pairs from the nearest
    gene when the found protospacer sequence is not located in a gene.
}

The following columns are also stored when a \code{tssObject} is provided:

\itemize{
\item \code{promoters} Character vector specifying gene names of promoters,
    as defined by \code{tss_window} relative to the gene TSS, overlapping
    the found protospacer sequence.
}
}
\examples{

if (interactive()){
# Creating a bowtie index:
library(Rbowtie)
library(BSgenome.Hsapiens.UCSC.hg38)
fasta <- system.file(package="crisprDesign", "fasta/chr12.fa")
outdir <- tempdir()
Rbowtie::bowtie_build(fasta,
                      outdir=outdir,
                      force=TRUE,
                      prefix="chr12")
bowtieIndex <- file.path(outdir, "chr12")

# Adding spacer alignments with bowtie:
data(guideSetExample, package="crisprDesign")
data(grListExample, package="crisprDesign")
guideSet <- addSpacerAlignments(guideSetExample,
                                aligner="bowtie",
                                aligner_index=bowtieIndex,
                                bsgenome=BSgenome.Hsapiens.UCSC.hg38,
                                n_mismatches=2,
                                txObject=grListExample)
}


}
\author{
Jean-Philippe Fortin, Luke Hoberecht
}
