% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addCrispraiScores.R
\name{addCrispraiScores}
\alias{addCrispraiScores}
\alias{addCrispraiScores,GuideSet-method}
\alias{addCrispraiScores,PairedGuideSet-method}
\alias{addCrispraiScores,NULL-method}
\title{Add CRISPRa/CRISPRi on-target scores to
    a \linkS4class{GuideSet} object.}
\usage{
addCrispraiScores(object, ...)

\S4method{addCrispraiScores}{GuideSet}(
  object,
  gr,
  tssObject,
  geneCol = "gene_id",
  modality = c("CRISPRi", "CRISPRa"),
  chromatinFiles = NULL,
  fastaFile = NULL
)

\S4method{addCrispraiScores}{PairedGuideSet}(
  object,
  gr,
  tssObject,
  geneCol = "gene_id",
  modality = c("CRISPRi", "CRISPRa"),
  chromatinFiles = NULL,
  fastaFile = NULL
)

\S4method{addCrispraiScores}{NULL}(object)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{gr}{A \linkS4class{GRanges} object derived from \code{queryTss} used
to produce the \code{guideSet} object.}

\item{tssObject}{A \linkS4class{GRanges} object containing TSS coordinates
and annotation. The following columns must be present:
"ID", promoter", "tx_id" and "gene_symbol".}

\item{geneCol}{String specifying which column of the \code{tssObject} should
be used for a unique gene identified. "gene_id" by default.}

\item{modality}{String specifying which modality is used.
Must be either "CRISPRi" or "CRISPRa".}

\item{chromatinFiles}{Named character vector of length 3 specifying
BigWig files containing chromatin accessibility data. See
crisprScore vignette for more information.}

\item{fastaFile}{String specifying fasta file of the hg38 genome.}
}
\value{
\code{guideSet} with an added column for the CRISPRai score.
}
\description{
Add CRISPRa/CRISPRi on-target scores to a
   \linkS4class{GuideSet} object. Only available for SpCas9, and for 
   hg38 genome. Requires \pkg{crisprScore} package to be installed.
}
\seealso{
\code{\link{addOnTargetScores}} to add other on-target scores.
}
\author{
Jean-Philippe Fortin
}
