% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/GuideSet-class.R
\docType{class}
\name{crisprNuclease}
\alias{crisprNuclease}
\alias{targetOrigin}
\alias{customSequences}
\alias{bsgenome}
\alias{spacers}
\alias{protospacers}
\alias{pamSites}
\alias{snps}
\alias{alignments}
\alias{onTargets}
\alias{offTargets}
\alias{geneAnnotation}
\alias{tssAnnotation}
\alias{enzymeAnnotation}
\alias{editedAlleles}
\alias{txTable}
\alias{exonTable}
\alias{tssAnnotation<-}
\alias{geneAnnotation<-}
\alias{enzymeAnnotation<-}
\alias{snps<-}
\alias{alignments<-}
\alias{addCutSites}
\alias{GuideSet-class}
\alias{GuideSet}
\alias{targetOrigin,GuideSet-method}
\alias{customSequences,GuideSet-method}
\alias{bsgenome,GuideSet-method}
\alias{crisprNuclease,GuideSet-method}
\alias{spacers,GuideSet-method}
\alias{pams,GuideSet-method}
\alias{pamSites,GuideSet-method}
\alias{cutSites,GuideSet-method}
\alias{addCutSites,GuideSet-method}
\alias{protospacers,GuideSet-method}
\alias{spacerLength,GuideSet-method}
\alias{prototypeSequence,GuideSet-method}
\alias{pamLength,GuideSet-method}
\alias{pamSide,GuideSet-method}
\alias{snps,GuideSet-method}
\alias{alignments,GuideSet-method}
\alias{onTargets,GuideSet-method}
\alias{offTargets,GuideSet-method}
\alias{alignments<-,GuideSet-method}
\alias{geneAnnotation<-,GuideSet-method}
\alias{tssAnnotation<-,GuideSet-method}
\alias{enzymeAnnotation<-,GuideSet-method}
\alias{snps<-,GuideSet-method}
\alias{geneAnnotation,GuideSet-method}
\alias{editedAlleles,GuideSet-method}
\alias{tssAnnotation,GuideSet-method}
\alias{enzymeAnnotation,GuideSet-method}
\alias{txTable,GuideSet-method}
\alias{exonTable,GuideSet-method}
\title{An S4 class to store CRISPR gRNA sequences with modular annotations.}
\usage{
crisprNuclease(object, ...)

targetOrigin(object, ...)

customSequences(object, ...)

bsgenome(object, ...)

spacers(object, ...)

protospacers(object, ...)

pamSites(object, ...)

snps(object, ...)

alignments(object, ...)

onTargets(object, ...)

offTargets(object, ...)

geneAnnotation(object, ...)

tssAnnotation(object, ...)

enzymeAnnotation(object, ...)

editedAlleles(object, ...)

txTable(object, ...)

exonTable(object, ...)

tssAnnotation(object) <- value

geneAnnotation(object) <- value

enzymeAnnotation(object) <- value

snps(object) <- value

alignments(object) <- value

addCutSites(object, ...)

GuideSet(
  ids = NA_character_,
  protospacers = NA_character_,
  pams = NULL,
  seqnames = NA_character_,
  pam_site = 0L,
  strand = "*",
  CrisprNuclease = NULL,
  targetOrigin = c("bsgenome", "customSequences"),
  bsgenome = NULL,
  customSequences = NULL,
  ...,
  seqinfo = NULL,
  seqlengths = NULL
)

\S4method{targetOrigin}{GuideSet}(object)

\S4method{customSequences}{GuideSet}(object)

\S4method{bsgenome}{GuideSet}(object)

\S4method{crisprNuclease}{GuideSet}(object)

\S4method{spacers}{GuideSet}(object, as.character = FALSE, returnAsRna = FALSE)

\S4method{pams}{GuideSet}(object, as.character = FALSE, returnAsRna = FALSE)

\S4method{pamSites}{GuideSet}(object)

\S4method{cutSites}{GuideSet}(object)

\S4method{addCutSites}{GuideSet}(object)

\S4method{protospacers}{GuideSet}(
  object,
  as.character = FALSE,
  include.pam = FALSE,
  returnAsRna = FALSE
)

\S4method{spacerLength}{GuideSet}(object)

\S4method{prototypeSequence}{GuideSet}(object)

\S4method{pamLength}{GuideSet}(object)

\S4method{pamSide}{GuideSet}(object)

\S4method{snps}{GuideSet}(object, unlist = TRUE, use.names = TRUE)

\S4method{alignments}{GuideSet}(object, columnName = "alignments", unlist = TRUE, use.names = TRUE)

\S4method{onTargets}{GuideSet}(object, columnName = "alignments", unlist = TRUE, use.names = TRUE)

\S4method{offTargets}{GuideSet}(
  object,
  columnName = "alignments",
  max_mismatches = Inf,
  unlist = TRUE,
  use.names = TRUE
)

\S4method{alignments}{GuideSet}(object) <- value

\S4method{geneAnnotation}{GuideSet}(object) <- value

\S4method{tssAnnotation}{GuideSet}(object) <- value

\S4method{enzymeAnnotation}{GuideSet}(object) <- value

\S4method{snps}{GuideSet}(object) <- value

\S4method{geneAnnotation}{GuideSet}(
  object,
  unlist = TRUE,
  gene_id = NULL,
  tx_id = NULL,
  gene_symbol = NULL,
  use.names = TRUE
)

\S4method{editedAlleles}{GuideSet}(object, unlist = TRUE, use.names = TRUE)

\S4method{tssAnnotation}{GuideSet}(
  object,
  unlist = TRUE,
  gene_id = NULL,
  gene_symbol = NULL,
  use.names = TRUE
)

\S4method{enzymeAnnotation}{GuideSet}(object, unlist = TRUE, use.names = TRUE)

\S4method{txTable}{GuideSet}(object, unlist = TRUE, use.names = TRUE)

\S4method{exonTable}{GuideSet}(object, unlist = TRUE, use.names = TRUE)
}
\arguments{
\item{object}{\linkS4class{GuideSet} object.}

\item{...}{Additional arguments for class-specific methods}

\item{value}{Object to replace with}

\item{ids}{Character vector of unique gRNA ids. The ids can be anything,
as long as they are unique.}

\item{protospacers}{Character vector of protospacers sequences.}

\item{pams}{Character vector of PAM sequences.}

\item{seqnames}{Character vector of chromosome names.}

\item{pam_site}{Integer vector of PAM site coordinates.}

\item{strand}{Character vector of gRNA strand.
Only accepted values are "+" and "-".}

\item{CrisprNuclease}{\linkS4class{CrisprNuclease} object.}

\item{targetOrigin}{String specifying the origin of the DNA target.
Must be either 'bsgenome' or 'customSequences'.}

\item{bsgenome}{\linkS4class{BSgenome} object or string specifying
BSgenome package name. Must be specified when
\code{targetOrigin} is set to "bsgenome".}

\item{customSequences}{\linkS4class{DNAStringSet} object. Must be specified
when \code{targetOrigin} is set to "customSequences".}

\item{seqinfo}{A \linkS4class{Seqinfo} object containing informatioon
about the set of genomic sequences present in the target genome.}

\item{seqlengths}{\code{NULL}, or an integer vector named with
\code{levels(seqnames)} and containing the lengths (or NA) for
each level in \code{levels(seqnames)}.}

\item{as.character}{Should sequences be returned as a character
vector? FALSE by default, in which case sequences are returned
as a \linkS4class{DNAStringSet}.}

\item{returnAsRna}{Should the sequences be returned as RNA
instead of DNA? FALSE by default.}

\item{include.pam}{Should PAM sequences be included?
FALSE by default.}

\item{unlist}{Should the annotation be returned as
one table instead of a list? TRUE by default.}

\item{use.names}{Whether to include spacer IDs as (row)names (\code{TRUE}),
or as a separate column (\code{FALSE}).}

\item{columnName}{Name of the column storing the alignments annotation
to be retrieved.}

\item{max_mismatches}{What should be the maximum number of 
mismatches considered for off-targets? 
Inf by default.}

\item{gene_id}{Character vector of Ensembl gene IDs to subset gene
annotation data by. If NULL (default), all genes are considered.}

\item{tx_id}{Character vector of Ensembl transcript IDs to subset gene
annotation data by. If NULL (deafult), all transcript are considered.}

\item{gene_symbol}{Character vector of gene symbols to subset gene
annotation data by. If NULL (default), all genes are considered.}
}
\value{
A GuideSet object.
}
\description{
An S4 class to store CRISPR gRNA sequences with modular annotations.
}
\section{Functions}{
\itemize{
\item \code{GuideSet()}: Create a \linkS4class{GuideSet} object

}}
\section{Constructors}{

    Use the constructor \code{link{GuideSet}} to create a GuideSet object.
}

\section{Accessors}{

\describe{
    \item{\code{crisprNuclease}:}{To get \linkS4class{CrisprNuclease} object
        used to design gRNAs.}
    \item{\code{spacers}:}{To get spacer sequences.}
    \item{\code{protospacers}:}{To get protospacer sequences.}
    \item{\code{spacerLength}:}{To get spacer length.}
    \item{\code{pams}:}{To get PAM sequences.}
    \item{\code{pamSites}:}{To get PAM site coordinates.}
    \item{\code{pamLength}:}{To get PAM length.}
    \item{\code{pamSide}:}{To return the side of the PAM sequence with
        respect to the protospacer sequence.}
    \item{\code{prototypeSequence}:}{To get a prototype protospacer
        sequence.}
    \item{\code{cutSites}:}{To get cut sites.}
    \item{\code{alignments}:}{To get genomic alignments annotation.}
    \item{\code{onTargets}:}{To get on-target alignments annotation}
    \item{\code{offTargets}:}{To get off-target alignments annotation}
    \item{\code{snps}:}{Tp get SNP annotation.}
    \item{\code{geneAnnotation}:}{To get gene annotation.}
    \item{\code{tssAnnotation}:}{To get TSS annotation.}
    \item{\code{enzymeAnnotation}:}{To get restriction enzymes annotation.}
    \item{\code{editedAlleles}:}{To get edited alleles annotation.}
}
}

\examples{
protospacers <- c("AGGTCGTGTGTGGGGGGGGG",
                  "AGGTCGTGTGTGGGGGGGGG")
pams <- c("AGG", "CGG")
pam_site=c(10,11)
seqnames="chr7"
data(SpCas9, package="crisprBase")
CrisprNuclease <- SpCas9
strand=c("+", "-")
ids <- paste0("grna_", seq_along(protospacers))
gr <- GuideSet(ids=ids,
               protospacers=protospacers,
               pams=pams,
               seqnames=seqnames,
               CrisprNuclease=CrisprNuclease,
               pam_site=pam_site,
               strand=strand,
               targetOrigin="customSequences",
               customSequences=protospacers)

}
