% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countsimQCReport.R
\name{countsimQCReport}
\alias{countsimQCReport}
\title{Generate countsimQC report}
\usage{
countsimQCReport(
  ddsList,
  outputFile,
  outputDir = "./",
  outputFormat = NULL,
  showCode = FALSE,
  rmdTemplate = NULL,
  forceOverwrite = FALSE,
  savePlots = FALSE,
  description = NULL,
  maxNForCorr = 500,
  maxNForDisp = Inf,
  calculateStatistics = TRUE,
  subsampleSize = 500,
  kfrac = 0.01,
  kmin = 5,
  permutationPvalues = FALSE,
  nPermutations = NULL,
  knitrProgress = FALSE,
  quiet = FALSE,
  ignorePandoc = FALSE,
  useRAGG = FALSE,
  dpi = 96,
  ...
)
}
\arguments{
\item{ddsList}{Named list of \code{DESeqDataSets} or count matrices to
compare. See the \code{DESeq2} Bioconductor package
(http://bioconductor.org/packages/release/bioc/html/DESeq2.html) for more
information about the \code{DESeqDataSet} class. Each \code{DESeqDataSet}
object in the list should contain a count matrix, a data frame with sample
information and a design formula. The sample information and design formula
will be used to calculate dispersions appropriately. If count matrices are
provided, it is assumed that all columns represent replicate samples, and
the design formula ~1 will be used.}

\item{outputFile}{The file name of the final report. The extension must match
the selected \code{outputFormat} (i.e., either .html or .pdf).}

\item{outputDir}{The directory where the final report should be saved.}

\item{outputFormat}{The output format of the report. If set to NULL or
"html_document", an html report will be generated. If set to
"pdf_document", a pdf report will be generated.}

\item{showCode}{Whether or not to include the code in the final report.}

\item{rmdTemplate}{The Rmarkdown (.Rmd) file that will be used as the
template for generating the report. If set to NULL (default), the template
provided with the countsimQC package will be used. See Details for more
information.}

\item{forceOverwrite}{Whether to force overwrite existing output files when
saving the generated report and figures.}

\item{savePlots}{Whether to save the ggplot objects for all the output
figures, to allow additional fine-tuning and generation of individual
plots. Note that the resulting file can be quite large, especially when
many and/or large data sets are compared.}

\item{description}{A string (of arbitrary length) describing the content of
the generated report. This will be included in the beginning of the report.
If set to NULL, a default description listing the number and names of the
included data sets will be used.}

\item{maxNForCorr}{The maximal number of samples (features) for which
pairwise correlation coefficients will be calculated. If the number of
samples (features) exceeds this number, they will be randomly subsampled.}

\item{maxNForDisp}{The maximal number of samples that will be used to
estimate dispersions. By default, all samples are used. This can be lowered
to speed up calculations (and obtain approximate results) for large data
sets.}

\item{calculateStatistics}{Whether to calculate quantitative pairwise
statistics for comparing data sets in addition to generating the plots.}

\item{subsampleSize}{The number of randomly selected observations (samples,
features or pairs of samples or features) for which certain
(time-consuming) statistics will be calculated. Only used if
\code{calculateStatistics} = TRUE.}

\item{kmin, kfrac}{For statistics that require the extraction of the k nearest
neighbors of a given point, the number of neighbors will be max(kmin, kfrac
* nrow(df))}

\item{permutationPvalues}{Whether to calculate permutation p-values for
selected pairwise data set comparison statistics.}

\item{nPermutations}{The number of permutations to perform when calculating
permutation p-values for data set comparison statistics. Only used if
\code{permutationPvalues} = TRUE.}

\item{knitrProgress}{Whether to show the progress bar when the report is
generated.}

\item{quiet}{Whether to suppress warnings and progress messages when the
report is generated.}

\item{ignorePandoc}{Determines what to do if pandoc or pandoc-citeproc is
missing (if Sys.which("pandoc") or Sys.which("pandoc-citeproc") is ""). If
ignorePandoc is TRUE, only a warning is given. The figures will be
generated, but not the final report. If ignorePandoc is FALSE (default),
the execution stops immediately.}

\item{useRAGG}{Logical scalar, indicating whether to use ragg_png as the
graphics device in the report rather than the default png.}

\item{dpi}{Numeric scalar, setting the dpi of the generated plots. Only
used if \code{useRAGG} is \code{TRUE}.}

\item{...}{Other arguments that will be passed to \code{rmarkdown::render}.}
}
\value{
No value is returned, but a report is generated in the
  \code{outputDir} directory.
}
\description{
Generate a report comparing a range of characteristics across a collection of
one or more count data sets.
}
\details{
When the function is called, the template file (specified by
  \code{rmdTemplate}) will be copied into the output folder, and
  \code{rmarkdown::render} will be called to generate the final report. If
  there is already a .Rmd file with the same name in the output folder, the
  function will raise an error and stop, to avoid overwriting the existing
  file. The reason for this behaviour is that the copied template in the
  output folder will be deleted once the report is generated.
}
\examples{
## Load example data
data(countsimExample)
\dontrun{
## Generate report
countsimQCReport(countsimExample, outputDir = "./",
                 outputFile = "example.html")
}

}
\author{
Charlotte Soneson
}
