% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormMixClus-functions.R
\name{NormMixParam}
\alias{NormMixParam}
\title{Calculate the mean and covariance for a Normal mixture model}
\usage{
NormMixParam(
  coseqResults,
  y_profiles = NULL,
  K = NULL,
  digits = 3,
  plot = FALSE,
  ...
)
}
\arguments{
\item{coseqResults}{Object of class \code{coseqResults} or \code{RangedSummarizedExperiment}
(as output from the \code{NormMixClus} or \code{NormMixClusK} functions)}

\item{y_profiles}{y (\emph{n} x \emph{q}) matrix of observed profiles for \emph{n}
observations and \emph{q} variables, required for \code{x} of class \code{RangedSummarizedExperiment}}

\item{K}{The model used for parameter estimation for objects \code{x} of
class \code{coseq} or \code{NormMixClus}. When \code{NULL}, the model selected
by the ICL criterion is used; otherwise, \code{K} should designate the number
of clusters in the desired model}

\item{digits}{Integer indicating the number of decimal places to be used for output}

\item{plot}{If \code{true}, produce heatmaps to visualize the estimated per-cluster
correlation matrices}

\item{...}{Additional optional parameters to pass to \code{corrplot}, if desired}
}
\value{
\item{pi }{ Vector of dimension \emph{K} with the estimated cluster proportions from
the Gaussian mixture model, where \emph{K} is the number of clusters}
\item{mu }{ Matrix of dimension \emph{K} x \emph{d} containing the estimated mean
vector from the Gaussian mixture model, where \emph{d} is the
number of samples in the data \code{y_profiles} and \emph{K} is the number of clusters}
\item{Sigma }{ Array of dimension \emph{d} x \emph{d} x \emph{K} containing the
estimated covariance matrices from the Gaussian mixture model, where \emph{d} is the
number of samples in the data \code{y_profiles} and \emph{K} is the number of clusters}
\item{rho }{ Array of dimension \emph{d} x \emph{d} x \emph{K} containing the
estimated correlation matrices from the Gaussian mixture model, where \emph{d} is the
number of samples in the data \code{y_profiles} and \emph{K} is the number of clusters}
}
\description{
Calculates the mean and covariance parameters for a normal mixture model
of the form pK_Lk_Ck
}
\examples{
## Simulate toy data, n = 300 observations
set.seed(12345)
countmat <- matrix(runif(300*4, min=0, max=500), nrow=300, ncol=4)
countmat <- countmat[which(rowSums(countmat) > 0),]
profiles <- transformRNAseq(countmat, norm="none",
                            transformation="arcsin")$tcounts

conds <- rep(c("A","B","C","D"), each=2)

## Run the Normal mixture model for K = 2,3
## Object of class coseqResults
run <- NormMixClus(y=profiles, K=2:3, iter=5)
run

## Run the Normal mixture model for K=2
## Object of class SummarizedExperiment0
run2 <- NormMixClusK(y=profiles, K=2, iter=5)

## Summary of results
summary(run)

## Re-estimate mixture parameters for the model with K=2 clusters
param <- NormMixParam(run, y_profiles=profiles)

}
\author{
Andrea Rau, Cathy Maugis-Rabusseau
}
