% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scal_var.R
\name{scal_var_mat}
\alias{scal_var_mat}
\title{Generate a matrix of the scaled variance values}
\usage{
scal_var_mat(inp, batchvec = NULL)
}
\arguments{
\item{inp}{corralm object or matrix; embedding to compute scaled variances}

\item{batchvec}{vector; batch labels (can be numeric or char). Defaults to `NULL`, which is appropriate for using a corralm object. If using an embedding matrix for inp, then this argument must be given and length must correspond to number of rows in `inp`.}
}
\value{
matrix of the scaled variance values by PC (batches in rows; PCs in columns)
}
\description{
Generate a matrix of the scaled variance values
}
\examples{
dat <- matrix(rnorm(5000), ncol = 50)
bv <- rep(seq(3),c(10,30,60))
scal_var_mat(dat, bv)
}
