% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\docType{methods}
\name{CNV.bin}
\alias{CNV.bin}
\alias{CNV.bin,CNV.analysis-method}
\title{CNV.bin}
\usage{
CNV.bin(object, ...)

\S4method{CNV.bin}{CNV.analysis}(object)
}
\arguments{
\item{object}{\code{CNV.analysis} object.}

\item{...}{Additional parameters (\code{CNV.bin} generic, currently not used).}
}
\value{
\code{CNV.analysis} object.
}
\description{
Combine single probe intensitiy values into predefined bins.
}
\details{
The median intensity per bin is calculated. Bins are defined using \code{CNV.create_anno}. A value by which all probe and bin intensity values are shifted in subsequent analysis steps is calculated by minimizing the median absolute deviation from all bins to zero (ideally shifting the copy-neutral state to 0).
}
\examples{
# prepare
library(minfiData)
data(MsetEx)
d <- CNV.load(MsetEx)
data(detail_regions)
anno <- CNV.create_anno(detail_regions = detail_regions)

# create object
x <- CNV.fit(query = d['GroupB_1'], ref = d[c('GroupA_1', 'GroupA_2', 'GroupA_3')], anno)

# modify object
x <- CNV.bin(x)
#x <- CNV.detail(x)
#x <- CNV.segment(x)

# general information
x
show(x)

# coefficients of linear regression
coef(x)

# show or replace sample name
names(x)
names(x) <- 'Sample 1'
}
\author{
Volker Hovestadt \email{conumee@hovestadt.bio}
}
